package v4_13

import org.cyclos.entities.banking.AccountFeeLog
import org.cyclos.impl.banking.AccountFeeLogServiceLocal
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler
import org.springframework.jdbc.core.JdbcTemplate

import groovy.transform.Field
import groovy.transform.TypeChecked

@Field RawEntityManagerHandler rawEntityManagerHandler = binding.rawEntityManagerHandler
@Field AccountFeeLogServiceLocal accountFeeLogService = binding.accountFeeLogService
@Field JdbcTemplate jdbc = binding.jdbc

@TypeChecked
int process() {
    def ids = jdbc.queryForList("select id from running_fees", Long)
    ids.each { id ->
        def log = rawEntityManagerHandler.find(AccountFeeLog, id)
        accountFeeLogService.markFinished(log)
    }
    jdbc.execute("drop table running_fees")
    return ids.size()
}

return process()
