/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.TransactionFeedback;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.TransactionFeedbackServiceLocal;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.transactions.BasePaymentData;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.users.references.ReferenceLevel;
import org.cyclos.model.users.references.ReferenceStatisticsParams;
import org.cyclos.model.users.references.ReferenceStatisticsVO;
import org.cyclos.model.users.references.ReferenceType;
import org.cyclos.model.users.references.TransactionFeedbackDTO;
import org.cyclos.model.users.references.TransactionFeedbackData;
import org.cyclos.model.users.references.TransactionFeedbackEntryVO;
import org.cyclos.model.users.references.TransactionFeedbackQuery;
import org.cyclos.model.users.references.TransactionFeedbackSearchData;
import org.cyclos.model.users.references.TransactionFeedbackUpdateDTO;
import org.cyclos.model.users.references.TransactionFeedbackVO;
import org.cyclos.model.users.references.TransactionsAwaitingFeedbackQuery;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.users.UserServiceSecurity;
import org.cyclos.services.users.TransactionFeedbackService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TransactionFeedbackServiceSecurity
extends CRUDServiceSecurity<TransactionFeedbackDTO, TransactionFeedback, TransactionFeedbackData, TransactionVO>
implements TransactionFeedbackService {
    @Autowired
    private TransactionFeedbackServiceLocal transactionFeedbackService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private UserServiceSecurity userServiceSecurity;

    public TransactionFeedbackServiceSecurity() {
        super(TransactionFeedback.class);
    }

    public Long comment(TransactionVO transactionVO, ReferenceLevel referenceLevel, String string) throws FrameworkException, IllegalActionException {
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionVO);
        if (basePayment.isFromSystem() || basePayment.isToSystem()) {
            throw new IllegalActionException();
        }
        User user = basePayment.getFromUser();
        this.permission((BasicUser)user).my(new Permission[]{Permission.MY_TRANSACTION_FEEDBACKS_GIVE}).check();
        this.checkCanReceive(basePayment.getToUser());
        return this.transactionFeedbackService.comment(transactionVO, referenceLevel, string);
    }

    @Override
    public boolean doHasManageAccess(TransactionFeedback transactionFeedback) {
        return this.permission((BasicUser)transactionFeedback.getFrom()).user(new Permission[]{Permission.USER_TRANSACTION_FEEDBACKS_MANAGE}).granted();
    }

    @Override
    public boolean doHasViewAccess(TransactionFeedback transactionFeedback) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = this.canManage((BasicUser)transactionFeedback.getFrom()) || this.canManage((BasicUser)transactionFeedback.getTo());
        boolean bl4 = bl = transactionFeedback.getFrom().equals((Object)this.getLoggedUser()) || transactionFeedback.getTo().equals((Object)this.getLoggedUser());
        bl2 = bl ? this.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE, Permission.MY_TRANSACTION_FEEDBACKS_GIVE) : (this.isMember() && !bl3 ? this.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_VIEW) : this.hasPermission(Permission.USER_TRANSACTION_FEEDBACKS_MANAGE) && bl3);
        return (this.isRelatedToUser((BasicUser)transactionFeedback.getTo()) || this.isRelatedToUser((BasicUser)transactionFeedback.getFrom())) && bl2;
    }

    public TransactionFeedbackData getDataFromTransaction(TransactionVO transactionVO) {
        TransactionFeedback transactionFeedback = this.transactionFeedbackService.readPaymentAsSystemAndGetFeedback(transactionVO);
        return (TransactionFeedbackData)this.getData(transactionFeedback.getId());
    }

    public TransactionFeedbackData getGiveData(TransactionVO transactionVO) {
        return (TransactionFeedbackData)this.getDataForNew(transactionVO);
    }

    public TransactionFeedbackData getReplyData(TransactionVO transactionVO) {
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionVO);
        User user = basePayment.getToUser();
        this.permission((BasicUser)user).my(new Permission[]{Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE}).check();
        return this.transactionFeedbackService.getReplyData(transactionVO);
    }

    public TransactionFeedbackSearchData getSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        if (user == null || !this.userServiceSecurity.canViewProfile(user)) {
            throw new PermissionDeniedException();
        }
        TransactionFeedbackSearchData transactionFeedbackSearchData = this.transactionFeedbackService.getSearchData(userLocatorVO);
        transactionFeedbackSearchData.setEditable(this.permission((BasicUser)user).user(new Permission[]{Permission.USER_TRANSACTION_FEEDBACKS_MANAGE}).granted());
        transactionFeedbackSearchData.setCanComment(!user.isRemoved() && this.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_GIVE));
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        MemberProductAccessor memberProductAccessor = this.productsHandler.getAccessor((BasicUser)user).member();
        if (memberProductAccessor.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_GIVE)) {
            arrayList.add(ReferenceType.GIVEN);
        }
        if (memberProductAccessor.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE)) {
            arrayList.add(ReferenceType.RECEIVED);
        }
        transactionFeedbackSearchData.setDirections(arrayList);
        if (arrayList.size() == 1) {
            ((TransactionFeedbackQuery)transactionFeedbackSearchData.getQuery()).setReferenceType((ReferenceType)CollectionHelper.first(arrayList));
        } else {
            ((TransactionFeedbackQuery)transactionFeedbackSearchData.getQuery()).setReferenceType(ReferenceType.RECEIVED);
        }
        return transactionFeedbackSearchData;
    }

    public ReferenceStatisticsVO getStatistics(@NotNull ReferenceStatisticsParams referenceStatisticsParams) throws FrameworkException {
        this.checkView(referenceStatisticsParams.getOwner());
        return this.transactionFeedbackService.getStatistics(referenceStatisticsParams);
    }

    public TransactionFeedbackVO getTransactionFeedback(TransactionVO transactionVO) throws FrameworkException {
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionVO);
        if (basePayment.isFromSystem() || basePayment.isToSystem()) {
            throw new IllegalActionException();
        }
        User user = basePayment.getFromUser();
        this.permission((BasicUser)user).my(new Permission[]{Permission.MY_TRANSACTION_FEEDBACKS_GIVE}).check();
        return this.transactionFeedbackService.getTransactionFeedback(transactionVO);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, TransactionFeedback transactionFeedback) {
        return false;
    }

    public List<UserVO> listIgnoredUsers() {
        this.checkPermission(Permission.MY_TRANSACTION_FEEDBACKS_GIVE);
        return this.transactionFeedbackService.listIgnoredUsers();
    }

    public boolean markAsIgnored(UserLocatorVO userLocatorVO, boolean bl) {
        this.checkPermission(Permission.MY_TRANSACTION_FEEDBACKS_GIVE);
        this.checkRelatesToUser((IUser)userLocatorVO);
        return this.transactionFeedbackService.markAsIgnored(userLocatorVO, bl);
    }

    public void removeFromTransaction(TransactionVO transactionVO) {
        TransactionFeedback transactionFeedback = this.transactionFeedbackService.readPaymentAsSystemAndGetFeedback(transactionVO);
        this.remove(transactionFeedback.getId());
    }

    public Long reply(TransactionVO transactionVO, String string) throws FrameworkException, IllegalActionException {
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionVO);
        if (basePayment.getFeedback() == null) {
            throw new EntityNotFoundException();
        }
        User user = basePayment.getToUser();
        this.permission((BasicUser)user).my(new Permission[]{Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE}).check();
        return this.transactionFeedbackService.reply(transactionVO, string);
    }

    public Page<TransactionFeedbackEntryVO> search(TransactionFeedbackQuery transactionFeedbackQuery) {
        this.checkView(transactionFeedbackQuery.getOwner());
        Page page = this.transactionFeedbackService.search(transactionFeedbackQuery);
        page.stream().forEach(transactionFeedbackEntryVO -> transactionFeedbackEntryVO.setTransaction(this.getTransactionIfAccessible(transactionFeedbackEntryVO.getTransaction())));
        return page;
    }

    public Page<TransactionResultVO> searchTransactionsAwaitingFeedback(TransactionsAwaitingFeedbackQuery transactionsAwaitingFeedbackQuery) {
        User user = transactionsAwaitingFeedbackQuery.getFrom() == null ? this.getLoggedUser() : (User)this.conversionHandler.convert(User.class, (Object)transactionsAwaitingFeedbackQuery.getFrom());
        this.permission((BasicUser)user).my(new Permission[]{Permission.MY_TRANSACTION_FEEDBACKS_GIVE}).user(new Permission[]{Permission.USER_TRANSACTION_FEEDBACKS_MANAGE}).check();
        return this.transactionFeedbackService.searchTransactionsAwaitingFeedback(transactionsAwaitingFeedbackQuery);
    }

    public void setFeedbackActions(BasePayment basePayment, BasePaymentData basePaymentData) {
        SessionData sessionData = this.getSessionData();
        basePaymentData.setCanViewFeedback(basePaymentData.isCanViewFeedback() && sessionData.hasPermission(this.isUserManager() ? Permission.USER_TRANSACTION_FEEDBACKS_MANAGE : Permission.MY_TRANSACTION_FEEDBACKS_VIEW));
        if (basePaymentData.isCanGiveFeedback()) {
            User user = basePayment.getToUser();
            basePaymentData.setCanGiveFeedback(this.canReceive(user) && sessionData.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_GIVE));
        }
        basePaymentData.setCanReplyFeedback(basePaymentData.isCanReplyFeedback() && sessionData.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE));
    }

    public void updateFeedbackFromTransaction(TransactionVO transactionVO, TransactionFeedbackUpdateDTO transactionFeedbackUpdateDTO) {
        TransactionFeedback transactionFeedback = this.transactionFeedbackService.readPaymentAsSystemAndGetFeedback(transactionVO);
        this.checkManageAccess(transactionFeedback);
        this.transactionFeedbackService.updateFeedbackFromTransaction(transactionVO, transactionFeedbackUpdateDTO);
    }

    @Override
    protected void checkCreateNew(TransactionVO transactionVO) {
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionVO);
        this.permission((BasicUser)basePayment.getFromUser()).my(new Permission[]{Permission.MY_TRANSACTION_FEEDBACKS_GIVE}).check();
    }

    @Override
    protected void customizeData(TransactionFeedbackData transactionFeedbackData) {
        Long l = EntityVO.id((EntityVO)((TransactionFeedbackDTO)transactionFeedbackData.getDto()).getFrom());
        User user = l != null ? (User)this.rawEntityManagerHandler.find(User.class, l) : null;
        Long l2 = EntityVO.id((EntityVO)((TransactionFeedbackDTO)transactionFeedbackData.getDto()).getTo());
        User user2 = l2 != null ? (User)this.rawEntityManagerHandler.find(User.class, l2) : null;
        boolean bl = user2 != null && this.isRelatedToUser((BasicUser)user2);
        boolean bl2 = this.isFromOrToRemoved(user, user2);
        if (((TransactionFeedbackDTO)transactionFeedbackData.getDto()).getFrom() != null && ((TransactionFeedbackDTO)transactionFeedbackData.getDto()).getFrom().getId() == null || ((TransactionFeedbackDTO)transactionFeedbackData.getDto()).getTo() != null && ((TransactionFeedbackDTO)transactionFeedbackData.getDto()).getTo().getId() == null) {
            bl2 = true;
        }
        transactionFeedbackData.setEditable(user != null && this.permission((BasicUser)user).user(new Permission[]{Permission.USER_TRANSACTION_FEEDBACKS_MANAGE}).granted());
        transactionFeedbackData.setCanComment(transactionFeedbackData.isCanComment() && this.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_GIVE) && bl && !bl2 && this.canReceive(user2));
        transactionFeedbackData.setCanReply(transactionFeedbackData.isCanReply() && this.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE) && !bl2);
        transactionFeedbackData.setTransaction(this.getTransactionIfAccessible(transactionFeedbackData.getTransaction()));
    }

    protected TransactionFeedbackServiceLocal getImplementation() {
        return this.transactionFeedbackService;
    }

    private boolean canReceive(User user) {
        return this.productsHandler.getAccessor((BasicUser)user).product().hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE);
    }

    private void checkCanReceive(User user) {
        if (!this.canReceive(user)) {
            throw new PermissionDeniedException();
        }
    }

    private User checkView(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        boolean bl = false;
        boolean bl2 = this.canManage((BasicUser)user);
        boolean bl3 = user.equals((Object)this.getLoggedUser());
        if (bl3) {
            bl = this.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE, Permission.MY_TRANSACTION_FEEDBACKS_GIVE);
        } else if (this.isMember() && !bl2) {
            bl = this.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_VIEW);
        } else {
            boolean bl4 = bl = this.hasPermission(Permission.USER_TRANSACTION_FEEDBACKS_MANAGE) && bl2;
        }
        if (!bl) {
            throw new PermissionDeniedException();
        }
        return user;
    }

    private TransactionVO getTransactionIfAccessible(TransactionVO transactionVO) {
        if (transactionVO == null) {
            return null;
        }
        try {
            this.conversionHandler.convert(BasePayment.class, (Object)transactionVO);
            return transactionVO;
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return null;
        }
    }

    private boolean isFromOrToRemoved(User user, User user2) {
        return user != null && user.getStatus().isRemoved() || user2 != null && user2.getStatus().isRemoved();
    }
}

