/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import com.querydsl.core.types.Path;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.QProductManagement;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.users.ProductsGroupServiceLocal;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.GroupProductsCollections;
import org.cyclos.model.users.products.ActiveProductsData;
import org.cyclos.model.users.products.ProductAssignmentLogVO;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.users.GroupServiceSecurity;
import org.cyclos.services.users.ProductsGroupService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ProductsGroupServiceSecurity
extends BaseServiceSecurity
implements ProductsGroupService {
    @Autowired
    private ProductsGroupServiceLocal productsGroupService;
    @Autowired
    private GroupServiceSecurity groupServiceSecurity;

    public boolean assign(ProductVO productVO, BasicGroupVO basicGroupVO) {
        BasicGroup basicGroup = (BasicGroup)this.conversionHandler.convert(BasicGroup.class, (Object)basicGroupVO);
        this.checkAssignPermission(productVO, basicGroup);
        return this.productsGroupService.assign(productVO, (EntityVO)basicGroupVO);
    }

    public ActiveProductsData getActiveProducts(BasicGroupVO basicGroupVO, ChannelVO channelVO, PrincipalTypeVO principalTypeVO) throws FrameworkException {
        BasicGroup basicGroup = (BasicGroup)this.conversionHandler.convert(BasicGroup.class, (Object)basicGroupVO);
        this.groupServiceSecurity.checkViewAccess(basicGroup);
        return this.productsGroupService.getActiveProducts((EntityVO)basicGroupVO, channelVO, principalTypeVO);
    }

    public GroupProductsCollections getData(BasicGroupVO basicGroupVO) throws FrameworkException {
        BasicGroup basicGroup = (BasicGroup)this.conversionHandler.convert(BasicGroup.class, (Object)basicGroupVO);
        this.groupServiceSecurity.checkViewAccess(basicGroup);
        return (GroupProductsCollections)this.productsGroupService.getData((EntityVO)basicGroupVO);
    }

    public List<ProductAssignmentLogVO> getLogs(@NotNull BasicGroupVO basicGroupVO) throws FrameworkException {
        BasicGroup basicGroup = (BasicGroup)this.conversionHandler.convert(BasicGroup.class, (Object)basicGroupVO);
        this.groupServiceSecurity.checkViewAccess(basicGroup);
        return this.productsGroupService.getLogs((EntityVO)basicGroupVO);
    }

    public boolean unassign(ProductVO productVO, BasicGroupVO basicGroupVO) {
        BasicGroup basicGroup = (BasicGroup)this.conversionHandler.convert(BasicGroup.class, (Object)basicGroupVO);
        this.checkAssignPermission(productVO, basicGroup);
        return this.productsGroupService.unassign(productVO, (EntityVO)basicGroupVO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private void checkAssignPermission(ProductVO productVO, BasicGroup basicGroup) {
        boolean bl;
        Product product = (Product)this.conversionHandler.convert(Product.class, (Object)productVO);
        QProductManagement qProductManagement = QProductManagement.productManagement;
        boolean bl2 = bl = this.hasPermission(Permission.USER_CONFIGURATION_MANAGE) || this.getSessionData().getProducts().admin().getManagedProducts().isSet((Object)product, (Path)qProductManagement.assignToGroups);
        if (!this.groupServiceSecurity.hasManageAccess(basicGroup) || !bl) {
            throw new PermissionDeniedException();
        }
    }
}

