/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.Collection;
import java.util.Collections;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.InternalBasicUserServiceLocal;
import org.cyclos.impl.users.MemberOrBrokerProductAccessor;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.users.operators.OperatorDTO;
import org.cyclos.model.users.operators.OperatorData;
import org.cyclos.model.users.operators.OperatorDataParams;
import org.cyclos.model.users.operators.OperatorQuery;
import org.cyclos.model.users.operators.OperatorRegistrationDTO;
import org.cyclos.model.users.operators.OperatorWithFieldsVO;
import org.cyclos.model.users.operators.OperatorsSearchData;
import org.cyclos.model.users.operators.ViewOperatorProfileData;
import org.cyclos.model.users.users.BasicUserDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserRegistrationResult;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.system.EntityLogServiceSecurity;
import org.cyclos.services.users.OperatorService;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class OperatorServiceSecurity
extends CRUDServiceSecurity<OperatorDTO, Operator, OperatorData, OperatorDataParams>
implements OperatorService {
    @Autowired
    private OperatorServiceLocal operatorService;
    @Autowired
    private InternalBasicUserServiceLocal internalBasicUserService;
    @Autowired
    private EntityLogServiceSecurity entityLogServiceSecurity;

    public OperatorServiceSecurity() {
        super(Operator.class);
    }

    public boolean canManageOperators(User user) {
        MemberOrBrokerProductAccessor memberOrBrokerProductAccessor = this.productsHandler.getAccessor((BasicUser)user).memberOrBroker();
        if (!memberOrBrokerProductAccessor.hasPermission(Permission.MY_OPERATORS_ENABLE)) {
            return false;
        }
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_OPERATORS_MANAGE_OPERATORS}).user(new Permission[]{Permission.USER_OPERATORS_MANAGE}).granted();
    }

    @Override
    public boolean canPerformOperation(Operator operator, CRUDOperation cRUDOperation) {
        if (cRUDOperation == CRUDOperation.UPDATE) {
            if (operator.isRemoved()) {
                return false;
            }
            BasicUser basicUser = this.getSessionData().getLoggedBasicUser();
            if (basicUser != null && basicUser.equals((Object)operator)) {
                Operator operator2 = (Operator)basicUser;
                return operator2.getGroup() == null || operator2.getGroup().isEditOwnProfile();
            }
        }
        return super.canPerformOperation(operator, cRUDOperation);
    }

    public boolean canViewOperators(User user) {
        MemberOrBrokerProductAccessor memberOrBrokerProductAccessor = this.productsHandler.getAccessor((BasicUser)user).memberOrBroker();
        if (!memberOrBrokerProductAccessor.hasPermission(Permission.MY_OPERATORS_ENABLE)) {
            return false;
        }
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_OPERATORS_ENABLE}).user(new Permission[]{Permission.USER_OPERATORS_VIEW}).granted();
    }

    @Override
    public boolean doHasViewAccess(Operator operator) {
        return this.canViewOperators(operator.getUser()) || operator.equals((Object)this.getLoggedBasicUser());
    }

    public OperatorsSearchData getSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        Object object = userLocatorVO != null ? this.userLocatorHandler.locate(userLocatorVO).getUser() : (sessionData.hasPermission(Permission.USER_OPERATORS_VIEW) ? null : sessionData.getLoggedUser());
        if (object != null && !this.canViewOperators((User)object)) {
            throw new PermissionDeniedException();
        }
        userLocatorVO = object == null ? null : new UserLocatorVO(object.getId());
        OperatorsSearchData operatorsSearchData = this.operatorService.getSearchData(userLocatorVO);
        operatorsSearchData.setCanCreateNew(object != null && !operatorsSearchData.isRemovedUser() && this.canManageOperators((User)object));
        return operatorsSearchData;
    }

    public ViewOperatorProfileData getViewProfileData(UserLocatorVO userLocatorVO) throws FrameworkException {
        ViewOperatorProfileData viewOperatorProfileData;
        Operator operator = (Operator)this.conversionHandler.convert(Operator.class, (Object)userLocatorVO);
        if (!this.canViewOperators(operator.getUser()) && !operator.equals((Object)this.getLoggedBasicUser())) {
            throw new PermissionDeniedException();
        }
        viewOperatorProfileData.setCanEditProfile((viewOperatorProfileData = this.operatorService.getViewProfileData(userLocatorVO)).isCanEditProfile() && this.operatorService.canEditProfile(operator));
        viewOperatorProfileData.getActions().setViewHistoryLog(this.entityLogServiceSecurity.canViewEntityLog((SimpleEntity)operator));
        return viewOperatorProfileData;
    }

    @Override
    public boolean isAccessible(SessionData sessionData, Operator operator) {
        return operator.getUser().equals((Object)sessionData.getLoggedUser());
    }

    public UserRegistrationResult register(OperatorRegistrationDTO operatorRegistrationDTO) throws FrameworkException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)operatorRegistrationDTO.getUser());
        if (!this.canManageOperators(user)) {
            throw new PermissionDeniedException();
        }
        return this.operatorService.register(operatorRegistrationDTO);
    }

    public Page<OperatorWithFieldsVO> search(OperatorQuery operatorQuery) throws FrameworkException {
        if (!this.checkQuery(operatorQuery)) {
            return PageImpl.empty();
        }
        return this.operatorService.search(operatorQuery);
    }

    @Override
    protected void checkCreateNew(OperatorDataParams operatorDataParams) {
        OperatorGroup operatorGroup;
        User user = (User)this.conversionHandler.convert(User.class, (Object)operatorDataParams.getUser());
        if (!this.canManageOperators(user)) {
            throw new PermissionDeniedException();
        }
        if (operatorDataParams.getGroupId() != null && !user.equals((Object)(operatorGroup = this.find(OperatorGroup.class, operatorDataParams.getGroupId())).getUser())) {
            throw new EntityNotFoundException();
        }
    }

    @Override
    protected boolean doHasManageAccess(Operator operator) {
        if (operator.isRemoved()) {
            return false;
        }
        SessionData sessionData = this.getSessionData();
        if (operator.equals((Object)sessionData.getLoggedBasicUser())) {
            OperatorGroup operatorGroup = operator.getGroup();
            return operatorGroup == null || operatorGroup.isEditOwnProfile();
        }
        return this.canManageOperators(operator.getUser());
    }

    @Override
    protected CRUDServiceLocal<Operator, OperatorDTO, OperatorData, OperatorDataParams> getImplementation() {
        return this.operatorService;
    }

    @Override
    protected void onBeforeSave(OperatorDTO operatorDTO, Operator operator) {
        this.internalBasicUserService.applyPermissionsToBasicFields((BasicUserDTO)operatorDTO, (BasicUser)operator);
    }

    private boolean checkQuery(OperatorQuery operatorQuery) {
        User user;
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)operatorQuery.getUser());
        User user2 = user = basicUser == null ? null : basicUser.getUser();
        if (user == null) {
            User user3 = sessionData.getLoggedUser();
            if (sessionData.hasPermission(Permission.USER_OPERATORS_VIEW)) {
                user = null;
                boolean bl = sessionData.isBroker();
                if (bl) {
                    operatorQuery.setBroker(new UserVO(user3.getId()));
                }
                this.groupsHandler.visibles().accessibles().basicUsers().check((Collection)operatorQuery.getUserGroups());
            } else {
                operatorQuery.setUser(new UserVO(user3.getId()));
            }
        } else {
            if (!this.canViewOperators(user)) {
                return false;
            }
            operatorQuery.setUserGroups(Collections.emptySet());
        }
        return true;
    }
}

