/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import javax.validation.constraints.NotNull;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Contact;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.ContactServiceLocal;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.users.contacts.ContactDTO;
import org.cyclos.model.users.contacts.ContactData;
import org.cyclos.model.users.contacts.ContactDataParams;
import org.cyclos.model.users.contacts.ContactQuery;
import org.cyclos.model.users.contacts.ContactSearchData;
import org.cyclos.model.users.contacts.ContactVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.ContactService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ContactServiceSecurity
extends CRUDServiceSecurity<ContactDTO, Contact, ContactData, ContactDataParams>
implements ContactService {
    @Autowired
    private ContactServiceLocal contactService;

    public ContactServiceSecurity() {
        super(Contact.class);
    }

    @Override
    public boolean doHasViewAccess(Contact contact) {
        return this.hasPermission(contact.getOwner(), false);
    }

    public ContactSearchData getSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.check(userLocatorVO, false);
        ContactSearchData contactSearchData = this.contactService.getSearchData(userLocatorVO);
        contactSearchData.setCanManage(this.hasPermission(user, true));
        return contactSearchData;
    }

    @Override
    public boolean isAccessible(SessionData sessionData, Contact contact) {
        return false;
    }

    public Page<ContactVO> search(ContactQuery contactQuery) throws FrameworkException {
        this.check(contactQuery.getOwner(), false);
        return this.contactService.search(contactQuery);
    }

    @Override
    protected void checkCreateNew(ContactDataParams contactDataParams) {
        this.check(contactDataParams == null ? null : contactDataParams.getOwner(), true);
        if (contactDataParams != null && contactDataParams.getContact() != null) {
            this.checkVO(User.class, (EntityVO)contactDataParams.getContact());
        }
    }

    @Override
    protected void customizeData(ContactData contactData) {
        if (contactData.isEditable() && CollectionHelper.isEmpty((Iterable)contactData.getEditableCustomFieldIds())) {
            contactData.setEditable(false);
        }
    }

    @Override
    protected boolean doHasManageAccess(Contact contact) {
        return this.hasPermission(contact.getOwner(), true);
    }

    protected ContactServiceLocal getImplementation() {
        return this.contactService;
    }

    private User check(UserLocatorVO userLocatorVO, boolean bl) {
        this.checkLoggedIn();
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        if (!this.hasPermission(user, bl)) {
            throw new PermissionDeniedException();
        }
        return user;
    }

    private boolean hasPermission(@NotNull User user, boolean bl) {
        if (!this.productsHandler.getAccessor((BasicUser)user).product().hasPermission(Permission.MY_CONTACTS_ENABLE) || !user.isActive() && !user.isBlocked()) {
            return false;
        }
        return this.permission((BasicUser)user).user(new Permission[]{bl ? Permission.USER_CONTACTS_MANAGE : Permission.USER_CONTACTS_VIEW}).my(new Permission[0]).granted();
    }
}

