/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactInfo;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.ContactInfoServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.users.contactinfos.ContactInfoDTO;
import org.cyclos.model.users.contactinfos.ContactInfoData;
import org.cyclos.model.users.contactinfos.ContactInfoListData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.ContactInfoService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ContactInfoServiceSecurity
extends CRUDServiceSecurity<ContactInfoDTO, ContactInfo, ContactInfoData, UserLocatorVO>
implements ContactInfoService {
    @Autowired
    private ContactInfoServiceLocal contactInfoService;

    public ContactInfoServiceSecurity() {
        super(ContactInfo.class);
    }

    public boolean canManageContactInfosOf(User user) {
        return this.isContactInfoEnabled(user) && this.permission((BasicUser)user).user(new Permission[]{Permission.USER_CONTACT_INFO_MANAGE}).my(new Permission[0]).granted();
    }

    @Override
    public boolean doHasViewAccess(ContactInfo contactInfo) {
        return this.canViewContactInfosOf(contactInfo.getUser());
    }

    public ContactInfoListData getContactInfoListData(UserLocatorVO userLocatorVO, boolean bl) throws FrameworkException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        if (!this.canViewContactInfosOf(user)) {
            throw new PermissionDeniedException();
        }
        return this.contactInfoService.getContactInfoListData(userLocatorVO, bl);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, ContactInfo contactInfo) {
        return sessionData.relatesTo((BasicUser)contactInfo.getUser());
    }

    @Override
    protected void checkCreateNew(UserLocatorVO userLocatorVO) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        if (!this.canManageContactInfosOf(user)) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected boolean doHasManageAccess(ContactInfo contactInfo) {
        User user = contactInfo.getUser();
        return this.canManageContactInfosOf(user);
    }

    protected ContactInfoServiceLocal getImplementation() {
        return this.contactInfoService;
    }

    private boolean canViewContactInfosOf(User user) {
        return this.isContactInfoEnabled(user) && this.getSessionData().relatesTo((BasicUser)user);
    }

    private boolean isContactInfoEnabled(User user) {
        int n = this.productsHandler.getAccessor((BasicUser)user).member().getMaxContactInfos();
        return n > 0;
    }
}

