/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanPath;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.BulkActionFile;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldValue;
import org.cyclos.entities.system.CustomFieldValueFile;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.system.CustomWizardField;
import org.cyclos.entities.system.MenuItemWizard;
import org.cyclos.entities.system.RegistrationWizard;
import org.cyclos.entities.system.TempFile;
import org.cyclos.entities.system.UserWizard;
import org.cyclos.entities.users.BaseContactInfo;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Contact;
import org.cyclos.entities.users.ContactCustomField;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QMemberProductCustomWizard;
import org.cyclos.entities.users.QProductAdField;
import org.cyclos.entities.users.QProductMyContactField;
import org.cyclos.entities.users.QProductMyProfileField;
import org.cyclos.entities.users.QProductMyRecordType;
import org.cyclos.entities.users.QProductOperatorProfileField;
import org.cyclos.entities.users.QProductRecordField;
import org.cyclos.entities.users.QProductSystemRecordType;
import org.cyclos.entities.users.QProductUserContactField;
import org.cyclos.entities.users.QProductUserProfileField;
import org.cyclos.entities.users.QProductUserRecordType;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.users.UserRecord;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.entities.utils.RawFile;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.MenuEntryServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.RawFileServiceLocal;
import org.cyclos.impl.users.ContactCustomFieldServiceLocal;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.contentmanagement.contentitems.ContentItemVisibility;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.products.ViewManageOperation;
import org.cyclos.model.users.recordfields.RecordFieldAction;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.security.banking.VoucherServiceSecurity;
import org.cyclos.security.users.BulkActionServiceSecurity;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.RawFileService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class RawFileServiceSecurity
extends BaseServiceSecurity
implements RawFileService {
    @Autowired
    private RawFileServiceLocal rawFileService;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    private RecordFieldHandler recordFieldHandler;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;
    @Autowired
    private VoucherServiceSecurity voucherServiceSecurity;
    @Autowired
    private ContactCustomFieldServiceLocal contactCustomFieldService;
    @Autowired
    private MenuEntryServiceLocal menuEntryService;
    @Autowired
    private BulkActionServiceSecurity bulkActionServiceSecurity;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkPermissionForNewTemp(CustomField<?, ?, ?> customField) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isGuest()) {
            int n;
            if (customField == null) throw new PermissionDeniedException();
            if (!(customField instanceof UserCustomField) && !(customField instanceof ContactInfoField)) {
                if (!(customField instanceof CustomWizardField)) throw new PermissionDeniedException();
                if (!(((CustomWizardField)customField).getWizard() instanceof RegistrationWizard)) {
                    throw new PermissionDeniedException();
                }
            }
            if ((n = sessionData.getConfiguration().getMaxGuestTempImages()) <= 0) {
                throw new PermissionDeniedException();
            }
            ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
            if (customField instanceof UserCustomField) {
                UserCustomField userCustomField = (UserCustomField)customField;
                BooleanPath booleanPath = QProductMyProfileField.productMyProfileField.editableAtRegistration;
                boolean bl = false;
                for (UserGroup userGroup : configurationAccessor.getPossibleInitialGroups()) {
                    ProductAccessor productAccessor = this.productsHandler.getAccessor((BasicGroup)userGroup).product();
                    if (productAccessor.getMyProfileFields().isSet((Object)BasicProfileField.IMAGE, (Path)booleanPath)) return;
                    if (userCustomField == null || !productAccessor.getMyProfileFields().isSet((Object)userCustomField, (Path)booleanPath)) continue;
                    return;
                }
                if (bl) return;
                throw new PermissionDeniedException();
            }
            if (customField instanceof ContactInfoField) {
                UserGroup userGroup;
                ContactInfoField contactInfoField = (ContactInfoField)customField;
                Iterator iterator = configurationAccessor.getPossibleInitialGroups().iterator();
                do {
                    if (!iterator.hasNext()) throw new PermissionDeniedException();
                } while (!this.productsHandler.getAccessor((BasicGroup)(userGroup = (UserGroup)iterator.next())).member().getContactInfoFields().contains(contactInfoField));
                return;
            }
            if (!(customField instanceof CustomWizardField)) throw new PermissionDeniedException();
            CustomWizard customWizard = ((CustomWizardField)customField).getWizard();
            if (customWizard.equals((Object)configurationAccessor.getLargeScreenRegistrationWizard())) return;
            if (customWizard.equals((Object)configurationAccessor.getMediumScreenRegistrationWizard())) return;
            if (customWizard.equals((Object)configurationAccessor.getSmallScreenRegistrationWizard())) return;
            throw new PermissionDeniedException();
        }
        ProductsAccessor productsAccessor = sessionData.getProducts();
        if (customField instanceof UserCustomField) {
            UserCustomField userCustomField = (UserCustomField)customField;
            if (productsAccessor.product().getMyProfileFields().isSet((Object)userCustomField, (Path)QProductMyProfileField.productMyProfileField.editable)) return;
            if (productsAccessor.userManagement().getUserProfileFields().isSet((Object)userCustomField, (Path)QProductUserProfileField.productUserProfileField.editable)) return;
            if (productsAccessor.member().getOperatorProfileFields().isSet((Object)userCustomField, (Path)QProductOperatorProfileField.productOperatorProfileField.editable)) return;
            if (!this.isEditableAtRegistration(userCustomField, sessionData)) throw new PermissionDeniedException();
            return;
        }
        if (customField instanceof AdCustomField) {
            AdCustomField adCustomField = (AdCustomField)customField;
            if (productsAccessor.member().getMyAdFields().isSet((Object)adCustomField, (Path)QProductAdField.productAdField.manage)) return;
            if (!productsAccessor.userManagement().getUserAdFields().isSet((Object)adCustomField, (Path)QProductAdField.productAdField.manage)) throw new PermissionDeniedException();
            return;
        }
        if (customField instanceof ContactCustomField) {
            ContactCustomField contactCustomField = (ContactCustomField)customField;
            if (productsAccessor.product().getMyContactFields().isSet((Object)contactCustomField, (Path)QProductMyContactField.productMyContactField.editable)) return;
            if (!productsAccessor.userManagement().getUserContactFields().isSet((Object)contactCustomField, (Path)QProductUserContactField.productUserContactField.editable)) throw new PermissionDeniedException();
            return;
        }
        if (customField instanceof ContactInfoField) {
            ContactInfoField contactInfoField = (ContactInfoField)customField;
            if (productsAccessor.member().getContactInfoFields().contains(contactInfoField)) return;
            if (!productsAccessor.userManagement().hasPermission(Permission.USER_CONTACT_INFO_MANAGE)) throw new PermissionDeniedException();
            return;
        }
        if (customField instanceof RecordCustomField) {
            BooleanPropertiesHolder booleanPropertiesHolder;
            RecordCustomField recordCustomField = (RecordCustomField)customField;
            for (UserRecordType userRecordType : productsAccessor.product().getMyRecordTypes().keysSet(CollectionHelper.asSet((Object[])new Path[]{QProductMyRecordType.productMyRecordType.create, QProductMyRecordType.productMyRecordType.edit}))) {
                booleanPropertiesHolder = productsAccessor.product().getMyRecordFields(userRecordType);
                if (booleanPropertiesHolder.isSet((Object)recordCustomField, (Path)QProductRecordField.productRecordField.create)) return;
                if (!booleanPropertiesHolder.isSet((Object)recordCustomField, (Path)QProductRecordField.productRecordField.edit)) continue;
                return;
            }
            for (UserRecordType userRecordType : productsAccessor.userManagement().getUserRecordTypes().keysSet(CollectionHelper.asSet((Object[])new Path[]{QProductUserRecordType.productUserRecordType.create, QProductUserRecordType.productUserRecordType.edit}))) {
                booleanPropertiesHolder = productsAccessor.userManagement().getUserRecordFields(userRecordType);
                if (booleanPropertiesHolder.isSet((Object)recordCustomField, (Path)QProductRecordField.productRecordField.create)) return;
                if (!booleanPropertiesHolder.isSet((Object)recordCustomField, (Path)QProductRecordField.productRecordField.edit)) continue;
                return;
            }
            Iterator iterator = productsAccessor.admin().getSystemRecordTypes().keysSet(CollectionHelper.asSet((Object[])new Path[]{QProductSystemRecordType.productSystemRecordType.create, QProductSystemRecordType.productSystemRecordType.edit})).iterator();
            do {
                UserRecordType userRecordType;
                if (!iterator.hasNext()) throw new PermissionDeniedException();
                userRecordType = (SystemRecordType)iterator.next();
                booleanPropertiesHolder = productsAccessor.admin().getSystemRecordFields((SystemRecordType)userRecordType);
                if (booleanPropertiesHolder.isSet((Object)recordCustomField, (Path)QProductRecordField.productRecordField.create)) return;
            } while (!booleanPropertiesHolder.isSet((Object)recordCustomField, (Path)QProductRecordField.productRecordField.edit));
            return;
        }
        if (customField instanceof TransactionCustomField) {
            TransactionCustomField transactionCustomField = (TransactionCustomField)customField;
            if (!productsAccessor.product().getVisibleTransactionFields().contains(transactionCustomField)) throw new PermissionDeniedException();
            return;
        }
        if (customField instanceof CustomWizardField) {
            CustomWizardField customWizardField = (CustomWizardField)customField;
            CustomWizard customWizard = customWizardField.getWizard();
            switch (customWizard.getNature()) {
                case REGISTRATION: {
                    if (!sessionData.isGuest()) break;
                    return;
                }
                case SYSTEM: {
                    if (!productsAccessor.admin().getSystemWizardsRun().contains(customWizard)) break;
                    return;
                }
                case USER: {
                    QMemberProductCustomWizard qMemberProductCustomWizard = QMemberProductCustomWizard.memberProductCustomWizard;
                    if (productsAccessor.member().getWizards().isSet((Object)((UserWizard)customWizard), (Path)qMemberProductCustomWizard.run)) return;
                    if (!productsAccessor.userManagement().getUserWizards().contains(customWizard)) break;
                    return;
                }
                case MENU: {
                    EnumSet<ContentItemVisibility> enumSet = EnumSet.of(ContentItemVisibility.ALL);
                    enumSet.add(sessionData.isGuest() ? ContentItemVisibility.GUESTS : ContentItemVisibility.USERS);
                    List list = this.configurationHandler.getAncestors(sessionData.getConfiguration().getConfiguration());
                    if (this.menuEntryService.listByWizard((MenuItemWizard)customWizard).stream().filter(menuItem -> enumSet.contains(menuItem.getVisibility())).filter(menuItem -> list.contains(menuItem.getConfiguration())).count() <= 0L) break;
                    return;
                }
            }
            if (!(customWizard instanceof RegistrationWizard)) throw new PermissionDeniedException();
            if (!sessionData.isGuest()) throw new PermissionDeniedException();
            return;
        }
        if (!(customField instanceof VoucherCustomField)) throw new PermissionDeniedException();
        VoucherCustomField voucherCustomField = (VoucherCustomField)customField;
        if (!productsAccessor.product().getVisibleVoucherFields().contains(voucherCustomField)) throw new PermissionDeniedException();
    }

    public boolean hasManagePermission(RawFile rawFile) {
        return this.hasPermission(rawFile, true);
    }

    public boolean hasViewPermission(RawFile rawFile) {
        return this.hasPermission(rawFile, false);
    }

    public List<RawFileVO> listTemp(String string, CustomFieldVO customFieldVO) throws FrameworkException {
        CustomField customField = this.customFieldValueHandler.getCustomField(customFieldVO);
        this.checkPermissionForNewTemp(customField);
        return this.rawFileService.listTemp(string, customFieldVO);
    }

    public RawFileVO load(Long l) throws FrameworkException {
        this.checkView(l);
        return this.rawFileService.load(l);
    }

    public SerializableInputStream readContent(Long l) throws FrameworkException {
        this.checkView(l);
        return this.rawFileService.readContent(l);
    }

    public void remove(Long l) throws FrameworkException {
        this.checkManage(l);
        this.rawFileService.remove(l);
    }

    public void removeAll(List<Long> list) {
        for (Long l : list) {
            this.checkManage(l);
        }
        this.rawFileService.removeAll(list);
    }

    public void saveName(Long l, String string) throws FrameworkException {
        this.checkManage(l);
        this.rawFileService.saveName(l, string);
    }

    public RawFileVO saveTemp(String string, CustomFieldVO customFieldVO, String string2, String string3, SerializableInputStream serializableInputStream) throws FrameworkException {
        CustomField customField = this.customFieldValueHandler.getCustomField(customFieldVO);
        this.checkPermissionForNewTemp(customField);
        return this.rawFileService.saveTemp(string, customFieldVO, string2, string3, serializableInputStream);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<TempFile>(TempFile.class){

            public boolean isVisible(SessionData sessionData, TempFile tempFile) {
                return RawFileServiceSecurity.this.hasViewPermission((RawFile)tempFile);
            }
        };
    }

    private void checkManage(Long l) {
        RawFile rawFile = this.find(RawFile.class, l);
        if (!this.hasManagePermission(rawFile)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkView(Long l) {
        RawFile rawFile = this.find(RawFile.class, l);
        if (!this.hasViewPermission(rawFile)) {
            throw new PermissionDeniedException();
        }
    }

    private boolean hasPermission(RawFile rawFile, boolean bl) {
        SessionData sessionData = this.getSessionData();
        switch (rawFile.getNature()) {
            case IMPORTED: 
            case DOCUMENT: {
                return false;
            }
            case TEMP: {
                TempFile tempFile = (TempFile)rawFile;
                if (tempFile.getByUser() != null) {
                    return ObjectHelper.isOneOf((Object)tempFile.getByUser(), (Object[])new Object[]{sessionData.getLoggedUser(), InvocationContext.get().getAttribute((Object)"tempOwner")});
                }
                return sessionData.isGuest();
            }
            case BULK_ACTION: {
                BulkActionFile bulkActionFile = (BulkActionFile)rawFile;
                return bl ? this.bulkActionServiceSecurity.hasManageAccess(bulkActionFile.getBulkAction()) : this.bulkActionServiceSecurity.hasViewAccess(bulkActionFile.getBulkAction());
            }
            case CUSTOM_FIELD_VALUE: {
                CustomFieldValueFile customFieldValueFile = (CustomFieldValueFile)rawFile;
                CustomFieldValue customFieldValue = customFieldValueFile.getCustomFieldValue();
                SimpleEntity simpleEntity = customFieldValue.getOwner();
                CustomField customField = customFieldValue.getField();
                if (simpleEntity instanceof BasicUser) {
                    BasicUser basicUser = (BasicUser)simpleEntity;
                    UserCustomField userCustomField = (UserCustomField)customField;
                    return this.profileFieldHandler.isAllowed(basicUser, (ProfileField)userCustomField, bl ? ProfileFieldAction.EDIT : ProfileFieldAction.VIEW);
                }
                if (simpleEntity instanceof Contact) {
                    Contact contact = (Contact)simpleEntity;
                    List list = bl ? this.contactCustomFieldService.listEditable(contact.getOwner()) : this.contactCustomFieldService.listVisible(contact.getOwner());
                    return list.contains(customField);
                }
                if (simpleEntity instanceof BaseContactInfo) {
                    BaseContactInfo baseContactInfo = (BaseContactInfo)simpleEntity;
                    return baseContactInfo.getUser().equals((Object)sessionData.getLoggedUser()) || this.groupsHandler.getViewProfileOnGroups().contains(baseContactInfo.getUser().getGroup());
                }
                if (simpleEntity instanceof BasicAd) {
                    BasicAd basicAd = (BasicAd)simpleEntity;
                    AdCustomField adCustomField = (AdCustomField)customField;
                    ViewManageOperation viewManageOperation = this.adCustomFieldService.getOperation(adCustomField, basicAd.getOwner());
                    return bl ? viewManageOperation.manage() : viewManageOperation.view();
                }
                if (simpleEntity instanceof Record) {
                    Record record = (Record)simpleEntity;
                    RecordCustomField recordCustomField = (RecordCustomField)customField;
                    User user = null;
                    if (record instanceof UserRecord) {
                        user = ((UserRecord)record).getUser();
                    }
                    RecordFieldAction recordFieldAction = bl ? (record.isTransient() ? RecordFieldAction.CREATE : RecordFieldAction.EDIT) : RecordFieldAction.VIEW;
                    Set set = this.recordFieldHandler.getFieldActions(record.getType(), user, recordCustomField);
                    return set.contains(recordFieldAction);
                }
                if (simpleEntity instanceof Transaction) {
                    if (bl) {
                        return false;
                    }
                    Transaction transaction = (Transaction)simpleEntity;
                    TransactionCustomField transactionCustomField = (TransactionCustomField)customField;
                    return this.transactionServiceSecurity.isAccessible(transaction) && sessionData.getProducts().product().getVisibleTransactionFields().contains(transactionCustomField);
                }
                if (simpleEntity instanceof Voucher) {
                    VoucherCustomField voucherCustomField = (VoucherCustomField)customField;
                    return this.voucherServiceSecurity.isVisible((Voucher)simpleEntity) && sessionData.getProducts().product().getVisibleVoucherFields().contains(voucherCustomField);
                }
                if (!(simpleEntity instanceof VoucherPack)) break;
                VoucherCustomField voucherCustomField = (VoucherCustomField)customField;
                return sessionData.getProducts().product().getVisibleVoucherFields().contains(voucherCustomField) && this.voucherServiceSecurity.isVisible((VoucherPack)simpleEntity);
            }
        }
        return false;
    }

    private boolean isEditableAtRegistration(UserCustomField userCustomField, Group group) {
        return this.productsHandler.getAccessor((BasicGroup)group).product().getMyProfileFields().isSet((Object)userCustomField, (Path)QProductMyProfileField.productMyProfileField.editableAtRegistration);
    }

    private boolean isEditableAtRegistration(UserCustomField userCustomField, SessionData sessionData) {
        Function<Boolean, Boolean> function = bl -> this.groupsHandler.getPossibleRegistrationGroups(false, bl.booleanValue()).stream().anyMatch(group -> this.isEditableAtRegistration(userCustomField, (Group)group));
        boolean bl2 = function.apply(false);
        if (!bl2 && sessionData.isBroker()) {
            bl2 = function.apply(true);
        }
        return bl2;
    }
}

