/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.LicenseServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.licensing.BasicLicenseVO;
import org.cyclos.model.system.licensing.LicenseVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.LicenseService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class LicenseServiceSecurity
extends BaseServiceSecurity
implements LicenseService {
    @Autowired
    private LicenseServiceLocal licenseService;

    public BasicLicenseVO getBasicLicense() throws FrameworkException {
        return this.licenseService.getBasicLicense();
    }

    public LicenseVO getLicense() throws FrameworkException {
        this.check();
        return this.licenseService.getLicense();
    }

    public void offlineUpdate(SerializableInputStream serializableInputStream) throws FrameworkException {
        this.check();
        this.licenseService.offlineUpdate(serializableInputStream);
    }

    public void onlineUpdate() throws FrameworkException {
        this.check();
        this.licenseService.onlineUpdate();
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private void check() {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return;
        }
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (basicUser == null || !basicUser.isGlobalAdmin()) {
            throw new PermissionDeniedException();
        }
    }
}

