/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.system.ImportedFile;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.UserSpecificImportedFile;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ImportServiceLocal;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.imports.ImportSearchContext;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.ImportedFileData;
import org.cyclos.model.system.imports.ImportedFileDataParams;
import org.cyclos.model.system.imports.ImportedFileQuery;
import org.cyclos.model.system.imports.ImportedFileSearchData;
import org.cyclos.model.system.imports.ImportedFileVO;
import org.cyclos.model.system.imports.ImportedLineDTO;
import org.cyclos.model.system.imports.ImportedLineData;
import org.cyclos.model.system.imports.ImportedLineQuery;
import org.cyclos.model.system.imports.ImportedLineSearchData;
import org.cyclos.model.system.imports.ImportedLineVO;
import org.cyclos.model.system.imports.UserSpecificImportedFileDTO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.ImportService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ImportServiceSecurity
extends CRUDServiceSecurity<ImportedFileDTO, ImportedFile, ImportedFileData, ImportedFileDataParams>
implements ImportService {
    @Autowired
    private ImportServiceLocal importService;

    public ImportServiceSecurity() {
        super(ImportedFile.class);
    }

    public boolean abort(Long l) throws FrameworkException {
        this.checkId(ImportedFile.class, l);
        return this.importService.abort(l);
    }

    @Override
    public boolean doHasViewAccess(ImportedFile importedFile) {
        return this.doHasAccess(importedFile, false);
    }

    public ImportedLineData getImportedLineData(Long l) {
        ImportedLine importedLine = this.importService.findLine(l);
        ImportedFile importedFile = importedLine.getImportedFile();
        this.checkViewAccess(importedFile);
        ImportedLineData importedLineData = this.importService.getImportedLineData(l);
        boolean bl = this.hasManageAccess(importedFile);
        importedLineData.setEditable(importedLineData.isEditable() && bl);
        importedLineData.setCanInclude(importedLineData.isCanInclude() && bl);
        importedLineData.setCanSkip(importedLineData.isCanSkip() && bl);
        return importedLineData;
    }

    public List<ImportType> getImportTypesWithPermission(boolean bl) {
        SessionData sessionData = this.getSessionData();
        ArrayList<ImportType> arrayList = new ArrayList<ImportType>();
        for (ImportType importType : ImportType.values()) {
            if (!sessionData.hasPermission(importType.getGeneralPermission()) && !sessionData.hasPermission(importType.getMyPermission()) && !sessionData.hasPermission(importType.getUserViewPermission())) continue;
            arrayList.add(importType);
        }
        return arrayList;
    }

    public ImportedLineSearchData getLineSearchData(@NotNull Long l) throws FrameworkException {
        ImportedFile importedFile = (ImportedFile)this.find(l);
        ImportedLineSearchData importedLineSearchData = this.importService.getLineSearchData(l);
        boolean bl = this.getImportTypesWithPermission(true).contains(importedFile.getImportType());
        importedLineSearchData.setCanSkipOrInclude(importedLineSearchData.isCanSkipOrInclude() && bl);
        return importedLineSearchData;
    }

    public ImportedFileSearchData getSearchData(ImportSearchContext importSearchContext, UserLocatorVO userLocatorVO) throws FrameworkException {
        List<ImportType> list = this.getImportTypesWithPermission(false);
        list.retainAll(importSearchContext.getImportTypes());
        PermissionHelper.checkNotEmpty(list);
        if (importSearchContext.isUserSpecific() && userLocatorVO != null) {
            this.checkManagesUser((IUser)userLocatorVO);
        }
        ImportedFileSearchData importedFileSearchData = this.importService.getSearchData(importSearchContext, userLocatorVO);
        List<ImportType> list2 = this.getImportTypesWithPermission(true);
        list2.retainAll(importSearchContext.getImportTypes());
        importedFileSearchData.setAllowedImports(list2);
        return importedFileSearchData;
    }

    @Override
    public boolean isAccessible(SessionData sessionData, ImportedFile importedFile) {
        return false;
    }

    public void markAsSkipped(Long l, List<Long> list, boolean bl) throws FrameworkException {
        ImportedFile importedFile = (ImportedFile)this.find(l);
        this.checkManageAccess(importedFile);
        this.importService.markAsSkipped(l, list, bl);
    }

    public void process(Long l) {
        ImportedFile importedFile = (ImportedFile)this.find(l);
        this.checkManageAccess(importedFile);
        this.importService.process(l);
    }

    public void saveImportedLine(ImportedLineDTO importedLineDTO) {
        ImportedLine importedLine = this.importService.findLine(importedLineDTO.getId());
        ImportedFile importedFile = importedLine.getImportedFile();
        this.checkManageAccess(importedFile);
        this.importService.saveImportedLine(importedLineDTO);
    }

    public Page<ImportedFileVO> search(ImportedFileQuery importedFileQuery) throws FrameworkException {
        this.checkQueryParams(importedFileQuery);
        return this.importService.search(importedFileQuery);
    }

    public Page<ImportedLineVO> searchImportedLines(ImportedLineQuery importedLineQuery) {
        this.checkId(importedLineQuery.getImportedFileId());
        return this.importService.searchImportedLines(importedLineQuery);
    }

    public Long upload(ImportedFileDTO importedFileDTO, SerializableInputStream serializableInputStream, String string) throws FrameworkException {
        ImportedFileDataParams importedFileDataParams = new ImportedFileDataParams();
        importedFileDataParams.setImportType(this.importService.getImportType(importedFileDTO));
        if (importedFileDTO instanceof UserSpecificImportedFileDTO) {
            UserSpecificImportedFileDTO userSpecificImportedFileDTO = (UserSpecificImportedFileDTO)importedFileDTO;
            importedFileDataParams.setUser(ModelHelper.userLocator((UserVO)userSpecificImportedFileDTO.getUser()));
        }
        this.checkCreateNew(importedFileDataParams);
        return this.importService.upload(importedFileDTO, serializableInputStream, string);
    }

    @Override
    protected void checkCreateNew(ImportedFileDataParams importedFileDataParams) {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)importedFileDataParams.getUser());
        if (!this.doHasAccess(importedFileDataParams.getImportType(), user, true)) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected void customizeData(ImportedFileData importedFileData) {
        boolean bl = importedFileData.isEditable();
        importedFileData.setCanAbort(importedFileData.isCanAbort() && bl);
        importedFileData.setCanProcess(importedFileData.isCanProcess() && bl);
    }

    @Override
    protected boolean doHasManageAccess(ImportedFile importedFile) {
        return this.doHasAccess(importedFile, true);
    }

    protected ImportServiceLocal getImplementation() {
        return this.importService;
    }

    private void checkId(Long l) {
        this.checkId(ImportedFile.class, l);
    }

    private void checkQueryParams(ImportedFileQuery importedFileQuery) {
        ImportSearchContext importSearchContext = importedFileQuery.getContext();
        if (importSearchContext == null) {
            throw new ValidationException();
        }
        List<ImportType> list = this.getImportTypesWithPermission(false);
        if (!CollectionHelper.containsAny(list, (Collection)importSearchContext.getImportTypes())) {
            throw new PermissionDeniedException();
        }
        if (importSearchContext.isUserSpecific() && importedFileQuery.getUser() == null) {
            importedFileQuery.setUser((UserVO)ModelHelper.self());
        }
    }

    private boolean doHasAccess(ImportedFile importedFile, boolean bl) {
        ImportType importType = importedFile.getImportType();
        User user = null;
        if (importedFile instanceof UserSpecificImportedFile) {
            UserSpecificImportedFile userSpecificImportedFile = (UserSpecificImportedFile)importedFile;
            user = userSpecificImportedFile.getUser();
        }
        return this.doHasAccess(importType, user, bl);
    }

    private boolean doHasAccess(ImportType importType, User user, boolean bl) {
        if (importType.isUserSpecific()) {
            return this.permission((BasicUser)user).user(new Permission[]{bl ? importType.getUserManagePermission() : importType.getUserViewPermission()}).my(new Permission[]{importType.getMyPermission()}).granted();
        }
        return this.hasPermission(importType.getGeneralPermission());
    }
}

