/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomOperationField;
import org.cyclos.entities.system.CustomOperationFieldPossibleValue;
import org.cyclos.entities.system.CustomOperationFieldPossibleValueCategory;
import org.cyclos.impl.system.CustomOperationFieldServiceLocal;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.operationfields.CustomOperationFieldDTO;
import org.cyclos.model.system.operationfields.CustomOperationFieldData;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.security.Security;
import org.cyclos.security.system.BaseCustomFieldServiceSecurity;
import org.cyclos.security.system.CustomOperationServiceSecurity;
import org.cyclos.services.system.CustomOperationFieldService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class CustomOperationFieldServiceSecurity
extends BaseCustomFieldServiceSecurity<CustomOperationFieldDTO, CustomOperationField, CustomOperationFieldPossibleValueCategory, CustomOperationFieldPossibleValue, CustomOperationFieldData, CustomOperationVO>
implements CustomOperationFieldService {
    @Autowired
    private CustomOperationFieldServiceLocal customOperationFieldService;
    @Autowired
    private CustomOperationServiceSecurity customOperationServiceSecurity;

    public CustomOperationFieldServiceSecurity() {
        super(CustomOperationField.class);
    }

    @Override
    public boolean doHasManageAccess(CustomOperationField customOperationField) {
        return this.customOperationServiceSecurity.hasManageAccess(customOperationField.getCustomOperation());
    }

    @Override
    public boolean doHasViewAccess(CustomOperationField customOperationField) {
        return this.customOperationServiceSecurity.hasViewAccess(customOperationField.getCustomOperation());
    }

    public List<CustomFieldVO> list(CustomOperationVO customOperationVO) {
        CustomOperation customOperation = (CustomOperation)this.conversionHandler.convert(CustomOperation.class, (Object)customOperationVO);
        this.customOperationServiceSecurity.checkViewAccess(customOperation);
        return this.customOperationFieldService.list(customOperationVO);
    }

    @Override
    protected void checkCreateNew(CustomOperationVO customOperationVO) {
        CustomOperation customOperation = (CustomOperation)this.conversionHandler.convert(CustomOperation.class, (Object)customOperationVO);
        this.customOperationServiceSecurity.checkManageAccess(customOperation);
    }

    protected CustomOperationFieldServiceLocal getImplementation() {
        return this.customOperationFieldService;
    }
}

