/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.cyclos.entities.system.Configuration;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.configurations.ActiveConfigurationData;
import org.cyclos.model.system.configurations.ConfigurationDTO;
import org.cyclos.model.system.configurations.ConfigurationData;
import org.cyclos.model.system.configurations.ConfigurationDetailedVO;
import org.cyclos.model.system.configurations.ConfigurationQuery;
import org.cyclos.model.system.configurations.ConfigurationSearchData;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.ConfigurationService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ConfigurationServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<ConfigurationDTO, Configuration, ConfigurationData, ConfigurationVO>
implements ConfigurationService {
    @Autowired
    private ConfigurationServiceLocal configurationService;

    public ConfigurationServiceSecurity() {
        super(Configuration.class);
    }

    public void checkManageContent(Configuration configuration) {
        if (!this.hasManageContent(configuration)) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    public boolean doHasManageAccess(Configuration configuration) {
        return this.hasPermission(Permission.SYSTEM_CONFIGURATION_MANAGE) || this.permission(Permission.SPECIFIC_CONFIGURATION_MANAGE).value((Object)configuration).granted();
    }

    @Override
    public boolean doHasViewAccess(Configuration configuration) {
        return this.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) || this.permission(Permission.SPECIFIC_CONFIGURATION_MANAGE).value((Object)configuration).granted() || this.permission(Permission.SPECIFIC_CONFIGURATION_MANAGE_CONTENT).value((Object)configuration).granted();
    }

    public ActiveConfigurationData getActiveConfiguration(ConfigurationVO configurationVO) {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.checkViewAccess(configuration);
        return this.configurationService.getActiveConfiguration(configurationVO);
    }

    public ConfigurationVO getDefault() throws FrameworkException {
        return this.configurationService.getDefault();
    }

    public ConfigurationSearchData getSearchData() {
        this.checkViewPermission();
        return this.configurationService.getSearchData();
    }

    public boolean hasManageContent(Configuration configuration) {
        return this.hasPermission(Permission.SYSTEM_CONFIGURATION_MANAGE) || this.permission(Permission.SPECIFIC_CONFIGURATION_MANAGE).value((Object)configuration).granted() || this.permission(Permission.SPECIFIC_CONFIGURATION_MANAGE_CONTENT).value((Object)configuration).granted();
    }

    public boolean isVisibleForManageContent(Configuration configuration) {
        if (this.hasViewAccess(configuration)) {
            return true;
        }
        SessionData sessionData = this.getSessionData();
        if (sessionData.isAdmin()) {
            AdminProductAccessor adminProductAccessor = sessionData.getProducts().admin();
            List list = adminProductAccessor.getManageSpecificConfigurations();
            list.addAll(adminProductAccessor.getManageContentSpecificConfigurations());
            if (CollectionHelper.isNotEmpty((Iterable)list)) {
                for (Configuration configuration2 : list) {
                    if (!this.isAncestor(configuration, configuration2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<ConfigurationDetailedVO> list() throws FrameworkException {
        this.checkPermission(Permission.SYSTEM_CONFIGURATION_VIEW, Permission.SPECIFIC_CONFIGURATION_MANAGE, Permission.SPECIFIC_CONFIGURATION_MANAGE_CONTENT);
        return this.configurationService.list();
    }

    public Page<ConfigurationDetailedVO> search(ConfigurationQuery configurationQuery) throws FrameworkException {
        this.checkViewPermission();
        this.groupsHandler.visibles().accessibles().basicUsers().check((Collection)configurationQuery.getGroups());
        return this.configurationService.search(configurationQuery);
    }

    @Override
    protected void checkCreateNew(ConfigurationVO configurationVO) {
        this.checkPermission(Permission.SYSTEM_CONFIGURATION_MANAGE);
    }

    protected ConfigurationServiceLocal getImplementation() {
        return this.configurationService;
    }

    @Override
    protected void onBeforeSave(ConfigurationDTO configurationDTO, Configuration configuration) {
        if (!(this.isSystem() || this.getLoggedUser().isGlobal() || Objects.equals(configuration.getRootUrl(), configurationDTO.getRootUrl()))) {
            throw new PermissionDeniedException();
        }
    }

    private void checkViewPermission() {
        boolean bl;
        AdminProductAccessor adminProductAccessor = this.getSessionData().getProducts().admin();
        boolean bl2 = bl = CollectionHelper.isNotEmpty((Iterable)adminProductAccessor.getManageSpecificConfigurations()) || CollectionHelper.isNotEmpty((Iterable)adminProductAccessor.getManageContentSpecificConfigurations());
        if (!this.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) && !bl) {
            throw new PermissionDeniedException();
        }
    }

    private boolean isAncestor(Configuration configuration, Configuration configuration2) {
        while (configuration2 != null) {
            if (configuration2.equals((Object)configuration)) {
                return true;
            }
            configuration2 = configuration2.getParent();
        }
        return false;
    }
}

