/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.messaging;

import java.util.Set;
import org.cyclos.entities.messaging.ErrorLog;
import org.cyclos.entities.system.Network;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.messaging.ErrorLogServiceLocal;
import org.cyclos.impl.system.NetworkServiceLocal;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.messaging.errorlogs.ErrorLogDetailedVO;
import org.cyclos.model.messaging.errorlogs.ErrorLogQuery;
import org.cyclos.model.messaging.errorlogs.ErrorLogSearchData;
import org.cyclos.model.messaging.errorlogs.ErrorLogVO;
import org.cyclos.model.system.networks.NetworkQuery;
import org.cyclos.model.users.groups.AdminGroupVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.messaging.ErrorLogService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ErrorLogServiceSecurity
extends BaseServiceSecurity
implements ErrorLogService {
    @Autowired
    private ErrorLogServiceLocal errorLogService;
    @Autowired
    private NetworkServiceLocal networkService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    public ErrorLogSearchData getSearchData() throws FrameworkException {
        this.checkViewPermission();
        return this.errorLogService.getSearchData();
    }

    public ErrorLogDetailedVO load(Long l) throws EntityNotFoundException {
        this.checkViewPermission();
        this.checkNetwork(l);
        return this.errorLogService.load(l);
    }

    public void remove(Long l) {
        this.checkManagePermission();
        this.errorLogService.remove(l);
    }

    public void removeAll(Set<Long> set) {
        this.checkManagePermission();
        this.errorLogService.removeAll(set);
    }

    public Page<ErrorLogVO> search(ErrorLogQuery errorLogQuery) {
        this.checkViewPermission();
        return this.errorLogService.search(errorLogQuery);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<ErrorLog>(ErrorLog.class){

            public boolean isVisible(SessionData sessionData, ErrorLog errorLog) {
                return sessionData.hasPermission(Permission.ERROR_LOG_VIEW);
            }
        };
    }

    private void checkManagePermission() {
        this.checkPermission(Permission.ERROR_LOG_MANAGE);
    }

    private void checkNetwork(Long l) {
        boolean bl = false;
        ErrorLog errorLog = (ErrorLog)this.rawEntityManagerHandler.find(ErrorLog.class, l);
        Network network = this.getSessionData().getNetwork();
        if (network == null) {
            Object object;
            NetworkQuery networkQuery = new NetworkQuery();
            networkQuery.setUnlimited();
            if (!this.isGlobalAdmin()) {
                object = (AdminGroupVO)this.conversionHandler.convert(AdminGroupVO.class, (Object)this.getLoggedUser().getGroup());
                networkQuery.setManagedByGroup((AdminGroupVO)object);
            }
            bl = (object = this.conversionHandler.convertList(Network.class, (Iterable)this.networkService.search(networkQuery))).contains(errorLog.getNetwork()) || this.isGlobalAdmin() && errorLog.getNetwork() == null;
        } else {
            bl = network.equals((Object)errorLog.getNetwork());
        }
        if (!bl) {
            throw new PermissionDeniedException();
        }
    }

    private void checkViewPermission() {
        this.checkPermission(Permission.ERROR_LOG_VIEW);
    }
}

