/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.marketplace;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.marketplace.AdDeliveryMethod;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.marketplace.AdDeliveryMethodServiceLocal;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodDTO;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodData;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodVO;
import org.cyclos.model.marketplace.webshopdeliverymethods.UserAdDeliveryMethodsListData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.marketplace.AdDeliveryMethodService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AdDeliveryMethodServiceSecurity
extends CRUDServiceSecurity<AdDeliveryMethodDTO, AdDeliveryMethod, AdDeliveryMethodData, UserLocatorVO>
implements AdDeliveryMethodService {
    @Autowired
    private AdDeliveryMethodServiceLocal adDeliveryMethodService;

    public AdDeliveryMethodServiceSecurity() {
        super(AdDeliveryMethod.class);
    }

    @Override
    public boolean canPerformOperation(AdDeliveryMethod adDeliveryMethod, CRUDOperation cRUDOperation) {
        if (cRUDOperation == CRUDOperation.DELETE) {
            return this.actuallyHasManagePermission(adDeliveryMethod.getOwner());
        }
        return super.canPerformOperation(adDeliveryMethod, cRUDOperation);
    }

    @Override
    public boolean doHasManageAccess(AdDeliveryMethod adDeliveryMethod) {
        return !adDeliveryMethod.isRemovedFromOwner() && this.actuallyHasManagePermission(adDeliveryMethod.getOwner());
    }

    @Override
    public boolean doHasViewAccess(AdDeliveryMethod adDeliveryMethod) {
        return this.permissionOptionalValue(adDeliveryMethod.getOwner()).my(new Permission[]{Permission.MY_WEB_SHOP_ENABLE}).user(new Permission[]{Permission.USER_WEB_SHOP_SETTINGS_VIEW}).granted();
    }

    public UserAdDeliveryMethodsListData getListData(@NotNull UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.checkList(userLocatorVO);
        UserAdDeliveryMethodsListData userAdDeliveryMethodsListData = this.adDeliveryMethodService.getListData(userLocatorVO);
        userAdDeliveryMethodsListData.setManage(this.actuallyHasManagePermission(user));
        return userAdDeliveryMethodsListData;
    }

    @Override
    public boolean isAccessible(SessionData sessionData, AdDeliveryMethod adDeliveryMethod) {
        return this.permissionOptionalValue(adDeliveryMethod.getOwner()).user(new Permission[]{Permission.USER_WEB_SHOP_VIEW}).granted();
    }

    public List<AdDeliveryMethodVO> list(UserLocatorVO userLocatorVO) {
        this.checkList(userLocatorVO);
        return this.adDeliveryMethodService.list(userLocatorVO);
    }

    @Override
    protected void checkCreateNew(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        this.permissionOptionalValue(user).my(new Permission[]{Permission.MY_WEB_SHOP_MANAGE}).user(new Permission[]{Permission.USER_WEB_SHOP_SETTINGS_MANAGE}).check();
    }

    protected User checkList(UserLocatorVO userLocatorVO) {
        User user = userLocatorVO == null ? this.getLoggedUser() : this.userLocatorHandler.locate(userLocatorVO).getUser();
        this.permissionOptionalValue(user).my(new Permission[]{Permission.MY_WEB_SHOP_ENABLE}).user(new Permission[]{Permission.USER_WEB_SHOP_SETTINGS_VIEW}).check();
        return user;
    }

    protected AdDeliveryMethodServiceLocal getImplementation() {
        return this.adDeliveryMethodService;
    }

    private boolean actuallyHasManagePermission(User user) {
        return this.permissionOptionalValue(user).my(new Permission[]{Permission.MY_WEB_SHOP_MANAGE}).user(new Permission[]{Permission.USER_WEB_SHOP_SETTINGS_MANAGE}).granted();
    }
}

