/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.banking.VoucherTemplate;
import org.cyclos.impl.banking.VoucherTemplateServiceLocal;
import org.cyclos.model.FileParsingException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.vouchertemplates.VoucherTemplateDTO;
import org.cyclos.model.banking.vouchertemplates.VoucherTemplateData;
import org.cyclos.model.banking.vouchertemplates.VoucherTemplateVO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.banking.VoucherTemplateService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class VoucherTemplateServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<VoucherTemplateDTO, VoucherTemplate, VoucherTemplateData, VoucherTemplateVO>
implements VoucherTemplateService {
    @Autowired
    private VoucherTemplateServiceLocal voucherTemplateService;

    public VoucherTemplateServiceSecurity() {
        super(VoucherTemplate.class);
    }

    @Override
    public boolean doHasViewAccess(VoucherTemplate voucherTemplate) {
        return this.hasPermission(Permission.VOUCHER_TEMPLATES_VIEW);
    }

    public FileInfo exportHTML(@NotNull VoucherTemplateDTO voucherTemplateDTO) throws FrameworkException {
        this.checkViewPermission();
        return this.voucherTemplateService.exportHTML(voucherTemplateDTO);
    }

    public FileInfo exportTemplate(@NotNull Long l) throws FrameworkException {
        this.checkViewPermission();
        return this.voucherTemplateService.exportTemplate(l);
    }

    public Long importTemplate(SerializableInputStream serializableInputStream) throws FrameworkException, FileParsingException {
        this.checkPermission(Permission.VOUCHER_TEMPLATES_MANAGE);
        return this.voucherTemplateService.importTemplate(serializableInputStream);
    }

    public List<VoucherTemplateVO> list() throws FrameworkException {
        this.checkViewPermission();
        return this.voucherTemplateService.list();
    }

    public SerializableInputStream preview(@NotNull VoucherTypeVO voucherTypeVO, @NotNull VoucherTemplateDTO voucherTemplateDTO) throws FrameworkException {
        this.checkViewPermission();
        return this.voucherTemplateService.preview(voucherTypeVO, voucherTemplateDTO);
    }

    @Override
    protected void checkCreateNew(VoucherTemplateVO voucherTemplateVO) {
        this.checkPermission(Permission.VOUCHER_TEMPLATES_MANAGE);
    }

    @Override
    protected boolean doHasManageAccess(VoucherTemplate voucherTemplate) {
        return !this.voucherTemplateService.isBuiltIn(voucherTemplate) && this.hasPermission(Permission.VOUCHER_TEMPLATES_MANAGE);
    }

    protected VoucherTemplateServiceLocal getImplementation() {
        return this.voucherTemplateService;
    }

    private void checkViewPermission() {
        this.checkPermission(Permission.VOUCHER_TEMPLATES_VIEW);
    }
}

