/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.TransferFilterServiceLocal;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.transferfilters.TransferFilterDTO;
import org.cyclos.model.banking.transferfilters.TransferFilterData;
import org.cyclos.model.banking.transferfilters.TransferFilterQuery;
import org.cyclos.model.banking.transferfilters.TransferFilterVO;
import org.cyclos.model.banking.transferfilters.TransferFilterWithAccountTypeVO;
import org.cyclos.security.Security;
import org.cyclos.security.SimpleConfigurationEntityCRUDServiceSecurity;
import org.cyclos.services.banking.TransferFilterService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TransferFilterServiceSecurity
extends SimpleConfigurationEntityCRUDServiceSecurity<TransferFilterDTO, TransferFilter, TransferFilterData, AccountTypeVO>
implements TransferFilterService {
    @Autowired
    private TransferFilterServiceLocal transferFilterService;

    public TransferFilterServiceSecurity() {
        super(TransferFilter.class, Permission.ACCOUNT_CONFIGURATION_VIEW, Permission.ACCOUNT_CONFIGURATION_MANAGE);
    }

    public List<TransferFilterWithAccountTypeVO> list(AccountTypeVO accountTypeVO, AccountTypeVO accountTypeVO2) throws FrameworkException {
        this.checkVO(AccountType.class, (EntityVO)accountTypeVO);
        this.checkVO(AccountType.class, (EntityVO)accountTypeVO2);
        List list = this.transferFilterService.list(accountTypeVO, accountTypeVO2);
        SessionData sessionData = this.getSessionData();
        HashSet hashSet = new HashSet(sessionData.getProducts().admin().getSystemTransferFilters());
        hashSet.addAll(sessionData.getProducts().member().getMyTransferFilters());
        hashSet.addAll(sessionData.getProducts().userManagement().getUserTransferFilters());
        List list2 = hashSet.stream().map(SimpleEntity::getId).collect(Collectors.toList());
        list.removeIf(transferFilterWithAccountTypeVO -> !list2.contains(transferFilterWithAccountTypeVO.getId()));
        return list;
    }

    public Page<TransferFilterVO> search(TransferFilterQuery transferFilterQuery) {
        this.checkViewPermission();
        return this.transferFilterService.search(transferFilterQuery);
    }

    protected TransferFilterServiceLocal getImplementation() {
        return this.transferFilterService;
    }
}

