/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.banking.TransferFee;
import org.cyclos.impl.banking.TransferFeeServiceLocal;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.transferfees.TransferFeeDTO;
import org.cyclos.model.banking.transferfees.TransferFeeData;
import org.cyclos.model.banking.transferfees.TransferFeeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeWithCurrencyVO;
import org.cyclos.security.Security;
import org.cyclos.security.SimpleConfigurationEntityCRUDServiceSecurity;
import org.cyclos.services.banking.TransferFeeService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TransferFeeServiceSecurity
extends SimpleConfigurationEntityCRUDServiceSecurity<TransferFeeDTO, TransferFee, TransferFeeData, TransferTypeVO>
implements TransferFeeService {
    @Autowired
    private TransferFeeServiceLocal transferFeeService;

    public TransferFeeServiceSecurity() {
        super(TransferFee.class, Permission.ACCOUNT_CONFIGURATION_VIEW, Permission.ACCOUNT_CONFIGURATION_MANAGE);
    }

    public List<TransferFeeVO> list(TransferTypeVO transferTypeVO) {
        this.checkViewPermission();
        return this.transferFeeService.list(transferTypeVO);
    }

    public List<TransferTypeWithCurrencyVO> listPossibleGeneratedTransferTypes(TransferFeeDTO transferFeeDTO) throws FrameworkException {
        this.checkViewPermission();
        return this.transferFeeService.listPossibleGeneratedTransferTypes(transferFeeDTO);
    }

    protected TransferFeeServiceLocal getImplementation() {
        return this.transferFeeService;
    }

    @Override
    protected void onBeforeSave(TransferFeeDTO transferFeeDTO, TransferFee transferFee) {
        Set set = this.groupsHandler.flattenVOs((Collection)transferFeeDTO.getFromGroups());
        Set set2 = this.groupsHandler.flattenVOs((Collection)transferFeeDTO.getToGroups());
        Set set3 = this.groupsHandler.accessibles().users().items();
        PermissionHelper.checkSelection((Collection)set3, (Collection)set, (boolean)true);
        PermissionHelper.checkSelection((Collection)set3, (Collection)set2, (boolean)true);
    }
}

