/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.List;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AuthorizationLevelServiceLocal;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.authorizationlevels.AuthorizationLevelDTO;
import org.cyclos.model.banking.authorizationlevels.AuthorizationLevelData;
import org.cyclos.model.banking.authorizationlevels.AuthorizationLevelVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.security.Security;
import org.cyclos.security.SimpleCRUDServiceSecurity;
import org.cyclos.security.banking.TransferTypeServiceSecurity;
import org.cyclos.services.banking.AuthorizationLevelService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AuthorizationLevelServiceSecurity
extends SimpleCRUDServiceSecurity<AuthorizationLevelDTO, AuthorizationLevel, AuthorizationLevelData, TransferTypeVO>
implements AuthorizationLevelService {
    @Autowired
    private AuthorizationLevelServiceLocal authorizationLevelService;
    @Autowired
    private TransferTypeServiceSecurity transferTypeServiceSecurity;

    public AuthorizationLevelServiceSecurity() {
        super(AuthorizationLevel.class, Permission.ACCOUNT_CONFIGURATION_VIEW, Permission.ACCOUNT_CONFIGURATION_MANAGE);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, AuthorizationLevel authorizationLevel) {
        return this.transferTypeServiceSecurity.isAccessible(sessionData, authorizationLevel.getTransferType());
    }

    public List<AuthorizationLevelVO> list(TransferTypeVO transferTypeVO) {
        this.checkViewPermission();
        return this.authorizationLevelService.list(transferTypeVO);
    }

    protected AuthorizationLevelServiceLocal getImplementation() {
        return this.authorizationLevelService;
    }
}

