/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import org.cyclos.entities.banking.AccountType;
import org.cyclos.impl.banking.AccountTypeServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.accounttypes.AccountTypeDTO;
import org.cyclos.model.banking.accounttypes.AccountTypeData;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.accounttypes.AccountTypeQuery;
import org.cyclos.model.banking.accounttypes.AccountTypeSearchData;
import org.cyclos.model.banking.accounttypes.AccountTypeWithCurrencyVO;
import org.cyclos.security.Security;
import org.cyclos.security.SimpleConfigurationEntityCRUDServiceSecurity;
import org.cyclos.services.banking.AccountTypeService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AccountTypeServiceSecurity
extends SimpleConfigurationEntityCRUDServiceSecurity<AccountTypeDTO, AccountType, AccountTypeData, AccountTypeNature>
implements AccountTypeService {
    @Autowired
    private AccountTypeServiceLocal accountTypeService;

    public AccountTypeServiceSecurity() {
        super(AccountType.class, Permission.ACCOUNT_CONFIGURATION_VIEW, Permission.ACCOUNT_CONFIGURATION_MANAGE);
    }

    public AccountTypeSearchData getSearchData() throws FrameworkException {
        this.checkViewPermission();
        AccountTypeSearchData accountTypeSearchData = this.accountTypeService.getSearchData();
        accountTypeSearchData.setCanManage(accountTypeSearchData.isCanManage() && this.hasManagePermission());
        return accountTypeSearchData;
    }

    public Page<AccountTypeWithCurrencyVO> search(AccountTypeQuery accountTypeQuery) {
        this.checkViewPermission();
        return this.accountTypeService.search(accountTypeQuery);
    }

    protected AccountTypeServiceLocal getImplementation() {
        return this.accountTypeService;
    }
}

