/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import java.util.Set;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.UserChannelServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.userchannels.UserChannelsData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.access.UserChannelService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class UserChannelServiceSecurity
extends BaseServiceSecurity
implements UserChannelService {
    @Autowired
    private UserChannelServiceLocal userChannelService;

    public UserChannelsData getChannelsData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        this.permission((BasicUser)user).my(new Permission[]{Permission.MY_CHANNELS_ACCESS_ENABLE}).user(new Permission[]{Permission.USER_CHANNELS_ACCESS_VIEW}).check();
        UserChannelsData userChannelsData = this.userChannelService.getChannelsData(userLocatorVO);
        userChannelsData.setEditable(this.permission((BasicUser)user).my(new Permission[]{Permission.MY_CHANNELS_ACCESS_ENABLE}).user(new Permission[]{Permission.USER_CHANNELS_ACCESS_MANAGE}).granted());
        return userChannelsData;
    }

    public void saveChannels(UserLocatorVO userLocatorVO, Set<ChannelVO> set) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        this.permission((BasicUser)user).my(new Permission[]{Permission.MY_CHANNELS_ACCESS_ENABLE}).user(new Permission[]{Permission.USER_CHANNELS_ACCESS_MANAGE}).check();
        this.userChannelService.saveChannels(userLocatorVO, set);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

