/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.access.NFCToken;
import org.cyclos.entities.access.NFCTokenPrincipalType;
import org.cyclos.entities.access.QNFCToken;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QProductMyTokenType;
import org.cyclos.entities.users.QProductTokenType;
import org.cyclos.entities.users.QProductUserTokenType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.TokenServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.devices.DeviceConfirmationBarcodeParams;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.access.principaltypes.TokenPermissionsVO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.access.tokens.ExternalNFCTagAuthenticateDTO;
import org.cyclos.model.access.tokens.ExternalNFCTagAuthenticateData;
import org.cyclos.model.access.tokens.InitializeNFCTagData;
import org.cyclos.model.access.tokens.InitializeNFCTagResult;
import org.cyclos.model.access.tokens.NFCTagInitializeDTO;
import org.cyclos.model.access.tokens.NFCTagKey;
import org.cyclos.model.access.tokens.NFCTagPersonalizeDTO;
import org.cyclos.model.access.tokens.PersonalizeNFCTagData;
import org.cyclos.model.access.tokens.TokenActionDTO;
import org.cyclos.model.access.tokens.TokenBarcodeParams;
import org.cyclos.model.access.tokens.TokenDTO;
import org.cyclos.model.access.tokens.TokenData;
import org.cyclos.model.access.tokens.TokenDataParams;
import org.cyclos.model.access.tokens.TokenQuery;
import org.cyclos.model.access.tokens.TokenSearchData;
import org.cyclos.model.access.tokens.TokenVO;
import org.cyclos.model.access.tokens.TokensListData;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.messaging.sms.SmsSendingException;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.users.OperatorServiceSecurity;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.access.TokenService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TokenServiceSecurity
extends CRUDServiceSecurity<TokenDTO, Token, TokenData, TokenDataParams>
implements TokenService {
    @Autowired
    private TokenServiceLocal tokenService;
    @Autowired
    private OperatorServiceSecurity operatorServiceSecurity;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;

    public TokenServiceSecurity() {
        super(Token.class);
    }

    public Long activate(TokenActionDTO tokenActionDTO, UserLocatorVO userLocatorVO) {
        TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)this.conversionHandler.convert(TokenPrincipalType.class, (Object)tokenActionDTO.getTokenType());
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        if (!this.hasPermissionToActivate(basicUser, tokenPrincipalType, !this.getSessionData().getLoggedBasicUser().equals((Object)basicUser))) {
            throw new PermissionDeniedException();
        }
        return this.tokenService.activate(tokenActionDTO, userLocatorVO);
    }

    public void activatePending(Long l) {
        Token token = (Token)this.find(l);
        if (!this.hasPermissionToActivate(token.getUser(), token.getType(), true)) {
            throw new PermissionDeniedException();
        }
        this.tokenService.activatePending(l);
    }

    public void assign(@NotNull Long l, @NotNull UserLocatorVO userLocatorVO) throws FrameworkException {
        Token token = (Token)this.find(l);
        if (!this.hasPermissionToAssign(token)) {
            throw new PermissionDeniedException();
        }
        this.tokenService.assign(l, userLocatorVO);
    }

    public SerializableInputStream barcode(TokenBarcodeParams tokenBarcodeParams) throws FrameworkException {
        return this.tokenService.barcode(tokenBarcodeParams);
    }

    public void block(Long l) {
        Token token = (Token)this.find(l);
        this.checkPermissionToBlock(token);
        this.tokenService.block(l);
    }

    public void cancel(Long l) {
        this.cancel((Token)this.find(l));
    }

    public void cancelNFCToken(TokenActionDTO tokenActionDTO) {
        QNFCToken qNFCToken = QNFCToken.nFCToken;
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)tokenActionDTO.getTokenType());
        NFCToken nFCToken = (NFCToken)((DBQuery)this.from(new EntityPath[]{qNFCToken}).where(new Predicate[]{qNFCToken.type().eq((Object)nFCTokenPrincipalType), qNFCToken.value.eq((Object)tokenActionDTO.getTokenValue())})).singleResult((Expression)qNFCToken);
        this.cancel((Token)nFCToken);
    }

    public DeviceConfirmationVO createDeviceConfirmationForPersonalizeNFCTag(@NotNull UserLocatorVO userLocatorVO, @NotNull TokenPrincipalTypeVO tokenPrincipalTypeVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)tokenPrincipalTypeVO);
        this.checkPermissionToPersonalize(basicUser, nFCTokenPrincipalType);
        return this.tokenService.createDeviceConfirmationForPersonalizeNFCTag(userLocatorVO, tokenPrincipalTypeVO);
    }

    public SerializableInputStream deviceConfirmationBarcodeForPersonalizeNFCTag(UserLocatorVO userLocatorVO, @NotNull TokenPrincipalTypeVO tokenPrincipalTypeVO, DeviceConfirmationBarcodeParams deviceConfirmationBarcodeParams) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)tokenPrincipalTypeVO);
        this.checkPermissionToPersonalize(basicUser, nFCTokenPrincipalType);
        return this.tokenService.deviceConfirmationBarcodeForPersonalizeNFCTag(userLocatorVO, tokenPrincipalTypeVO, deviceConfirmationBarcodeParams);
    }

    @Override
    public boolean doHasViewAccess(Token token) {
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        BasicUser basicUser2 = token.getUser();
        if (sessionData.isGuest() || basicUser2 != null && !basicUser2.equals((Object)basicUser) && (basicUser2.isOperator() && !this.operatorServiceSecurity.canViewOperators(basicUser2.getUser()) || !basicUser2.isOperator() && !sessionData.isManagerOf((BasicUser)basicUser2.getUser()))) {
            return false;
        }
        BooleanSupplier booleanSupplier = () -> {
            BooleanProperties booleanProperties = sessionData.getProducts().userManagement().getUserTokenTypes().get((Object)token.getType());
            return booleanProperties != null && booleanProperties.isSet((Path)QProductUserTokenType.productUserTokenType.view);
        };
        if (basicUser2 != null) {
            if (basicUser2.equals((Object)basicUser) || sessionData.isOwnerOf(basicUser2)) {
                BooleanProperties booleanProperties = sessionData.getProducts().member().getMyTokenTypes().get((Object)token.getType());
                return booleanProperties != null && booleanProperties.isSet((Path)QProductMyTokenType.productMyTokenType.enable);
            }
            if (sessionData.isManagerOf(basicUser2)) {
                return booleanSupplier.getAsBoolean();
            }
            return false;
        }
        return booleanSupplier.getAsBoolean();
    }

    public FileInfo exportTokens(@NotNull ExportFormatVO exportFormatVO, @NotNull TokenQuery tokenQuery) throws FrameworkException {
        if (!this.getSessionData().isUserManager()) {
            throw new PermissionDeniedException();
        }
        if (!this.checkQuery(tokenQuery)) {
            return null;
        }
        return this.tokenService.exportTokens(exportFormatVO, tokenQuery);
    }

    public InitializeNFCTagData getInitializeNFCTagData() throws FrameworkException {
        InitializeNFCTagData initializeNFCTagData = this.tokenService.getInitializeNFCTagData();
        List list = this.principalTypeService.listUserTokenPermissions((BasicUser)null);
        initializeNFCTagData.setInitializeTokenTypes(list.stream().filter(TokenPermissionsVO::isCreate).map(TokenPermissionsVO::getType).filter(tokenPrincipalTypeVO -> tokenPrincipalTypeVO.getTokenType().isNFCTag()).collect(Collectors.toList()));
        initializeNFCTagData.setPersonalizeTokenTypes(list.stream().filter(TokenPermissionsVO::isActivate).map(TokenPermissionsVO::getType).filter(tokenPrincipalTypeVO -> tokenPrincipalTypeVO.getTokenType().isNFCTag()).collect(Collectors.toList()));
        return initializeNFCTagData;
    }

    public TokensListData getListData(TokenPrincipalTypeVO tokenPrincipalTypeVO, UserLocatorVO userLocatorVO) throws FrameworkException {
        TokensListData tokensListData;
        this.checkLoggedIn();
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        if (!this.canViewTokenOwner(basicUser)) {
            throw new PermissionDeniedException();
        }
        TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)this.conversionHandler.convert(TokenPrincipalType.class, (Object)tokenPrincipalTypeVO);
        tokensListData.setCanCreateNew((tokensListData = this.tokenService.getListData(tokenPrincipalTypeVO, userLocatorVO)).isCanCreateNew() && this.hasPermissionToCreateNew(basicUser, tokenPrincipalType));
        tokensListData.setCanActivateNew(tokensListData.isCanActivateNew() && this.hasPermissionToActivate(basicUser, tokenPrincipalType, !this.getSessionData().getLoggedBasicUser().equals((Object)basicUser)));
        return tokensListData;
    }

    public PersonalizeNFCTagData getPersonalizeNFCTagData(TokenPrincipalTypeVO tokenPrincipalTypeVO, UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)tokenPrincipalTypeVO);
        this.checkPermissionToPersonalize(basicUser, nFCTokenPrincipalType);
        boolean bl = this.principalTypeService.listUserTokenPermissions(basicUser).stream().anyMatch(tokenPermissionsVO -> nFCTokenPrincipalType.getId().equals(tokenPermissionsVO.getType().getId()) && tokenPermissionsVO.isActivate());
        if (!bl) {
            throw new PermissionDeniedException();
        }
        return this.tokenService.getPersonalizeNFCTagData(tokenPrincipalTypeVO, userLocatorVO);
    }

    public TokenSearchData getSearchData(TokenPrincipalTypeVO tokenPrincipalTypeVO) throws FrameworkException {
        if (!this.getSessionData().isUserManager()) {
            throw new PermissionDeniedException();
        }
        TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)this.conversionHandler.convert(TokenPrincipalType.class, (Object)tokenPrincipalTypeVO);
        TokenSearchData tokenSearchData = this.tokenService.getSearchData(tokenPrincipalTypeVO);
        tokenSearchData.setCreate(this.hasPermissionToCreateNew(null, tokenPrincipalType));
        tokenSearchData.setActivate(this.hasPermissionToActivate(null, tokenPrincipalType, true));
        return tokenSearchData;
    }

    public boolean hasPermissionToPersonalizeAtRegistration(UserGroup userGroup, NFCTokenPrincipalType nFCTokenPrincipalType, boolean bl) {
        SessionData sessionData = this.getSessionData();
        if (!this.groupsHandler.getPossibleRegistrationGroups(true, bl).contains(userGroup)) {
            return false;
        }
        boolean bl2 = false;
        if (sessionData.isAdmin() || sessionData.isBroker() && !bl) {
            bl2 = this.canPersonalizeAsManager(nFCTokenPrincipalType, sessionData);
        } else if (sessionData.isMember()) {
            bl2 = this.canPersonalizeAsMember(nFCTokenPrincipalType, sessionData);
        }
        return bl2 && this.isTokenPrincipalTypeEnabled((TokenPrincipalType)nFCTokenPrincipalType, this.productsHandler.getAccessor((BasicGroup)userGroup));
    }

    public InitializeNFCTagResult initializeNFCTag(NFCTagInitializeDTO nFCTagInitializeDTO) throws FrameworkException {
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)nFCTagInitializeDTO.getTokenType());
        this.checkPermissionToInitialize(nFCTokenPrincipalType);
        if (nFCTagInitializeDTO.getUser() != null) {
            BasicUser basicUser = this.userLocatorHandler.locate(nFCTagInitializeDTO.getUser()).getBasicUser();
            this.checkManagesUser(basicUser);
            this.checkPermissionToPersonalize(basicUser, nFCTokenPrincipalType);
        }
        return this.tokenService.initializeNFCTag(nFCTagInitializeDTO);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, Token token) {
        return false;
    }

    public void personalizeNFCTag(NFCTagPersonalizeDTO nFCTagPersonalizeDTO) throws FrameworkException {
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)nFCTagPersonalizeDTO.getTokenType());
        BasicUser basicUser = this.userLocatorHandler.locate(nFCTagPersonalizeDTO.getUser()).getBasicUser();
        this.checkPermissionToPersonalize(basicUser, nFCTokenPrincipalType);
        this.tokenService.personalizeNFCTag(nFCTagPersonalizeDTO);
    }

    public void removeDeviceConfirmationForPersonalizeNFCTag(@NotNull UserLocatorVO userLocatorVO, @NotNull TokenPrincipalTypeVO tokenPrincipalTypeVO, String string) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)tokenPrincipalTypeVO);
        this.checkPermissionToPersonalize(basicUser, nFCTokenPrincipalType);
        this.tokenService.removeDeviceConfirmationForPersonalizeNFCTag(userLocatorVO, tokenPrincipalTypeVO, string);
    }

    public ExternalNFCTagAuthenticateData requestForExternalAuthenticate(ExternalNFCTagAuthenticateDTO externalNFCTagAuthenticateDTO) throws FrameworkException {
        this.checkLoggedIn();
        NFCTagKey nFCTagKey = (NFCTagKey)ObjectHelper.defaultValue((Object)externalNFCTagAuthenticateDTO.getKeyType(), (Object)NFCTagKey.OPERATIONAL_KEY);
        NFCTokenPrincipalType nFCTokenPrincipalType = nFCTagKey == NFCTagKey.APP_MASTER_KEY ? null : (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)externalNFCTagAuthenticateDTO.getTokenType());
        switch (nFCTagKey) {
            case PICC_MASTER_KEY: {
                this.checkPermissionToInitialize(nFCTokenPrincipalType);
                break;
            }
            case APP_MASTER_KEY: {
                throw new PermissionDeniedException();
            }
            case OPERATIONAL_KEY: {
                UserLocatorVO userLocatorVO = new UserLocatorVO();
                userLocatorVO.setPrincipal(externalNFCTagAuthenticateDTO.getTokenValue());
                userLocatorVO.setPrincipalType(nFCTokenPrincipalType.getInternalName());
                try {
                    this.transactionService.locateForReceiving((InternalAccountOwner)userLocatorVO);
                    this.checkPermission(Permission.MY_PAYMENTS_RECEIVE);
                }
                catch (EntityNotFoundException | PermissionDeniedException throwable) {
                    if (externalNFCTagAuthenticateDTO.getUser() != null) {
                        this.checkPermissionToPersonalize(this.getUser((IUser)externalNFCTagAuthenticateDTO.getUser()), nFCTokenPrincipalType);
                        break;
                    }
                    if (externalNFCTagAuthenticateDTO.getGroup() != null) {
                        this.checkPermissionToPersonalizeAtRegistration((UserGroup)this.conversionHandler.convert(UserGroup.class, (Object)externalNFCTagAuthenticateDTO.getGroup()), nFCTokenPrincipalType, externalNFCTagAuthenticateDTO.isAsMember());
                        break;
                    }
                    this.checkPermissionToPersonalize(null, nFCTokenPrincipalType);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown NFC key type: " + String.valueOf(nFCTagKey));
            }
        }
        return this.tokenService.requestForExternalAuthenticate(externalNFCTagAuthenticateDTO);
    }

    public void requestNewOTPForPersonalizeNFCTag(UserLocatorVO userLocatorVO, TokenPrincipalTypeVO tokenPrincipalTypeVO, SendMedium sendMedium) throws FrameworkException, SmsSendingException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)tokenPrincipalTypeVO);
        this.checkPermissionToPersonalize(basicUser, nFCTokenPrincipalType);
        this.tokenService.requestNewOTPForPersonalizeNFCTag(userLocatorVO, tokenPrincipalTypeVO, sendMedium);
    }

    public Page<TokenVO> search(TokenQuery tokenQuery) throws FrameworkException, QueryParseException {
        if (!this.isUserManager()) {
            throw new PermissionDeniedException();
        }
        if (!this.checkQuery(tokenQuery)) {
            return PageImpl.empty();
        }
        return this.tokenService.search(tokenQuery);
    }

    public void setActivationDeadline(@NotNull Long l, DateTime dateTime) throws FrameworkException {
        Token token = (Token)this.find(l);
        if (!this.hasPermissionToChangeDates(token)) {
            throw new PermissionDeniedException();
        }
        this.tokenService.setActivationDeadline(l, dateTime);
    }

    public void setExpiryDate(@NotNull Long l, DateTime dateTime) throws FrameworkException {
        Token token = (Token)this.find(l);
        if (!this.hasPermissionToChangeDates(token)) {
            throw new PermissionDeniedException();
        }
        this.tokenService.setExpiryDate(l, dateTime);
    }

    public void unblock(Long l) {
        Token token = (Token)this.find(l);
        if (!this.hasPermissionToUnblock(token)) {
            throw new PermissionDeniedException();
        }
        this.tokenService.unblock(l);
    }

    public DeviceConfirmationVO viewDeviceConfirmationForPersonalizeNFCTag(@NotNull UserLocatorVO userLocatorVO, @NotNull TokenPrincipalTypeVO tokenPrincipalTypeVO, String string) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)tokenPrincipalTypeVO);
        this.checkPermissionToPersonalize(basicUser, nFCTokenPrincipalType);
        return this.tokenService.viewDeviceConfirmationForPersonalizeNFCTag(userLocatorVO, tokenPrincipalTypeVO, string);
    }

    @Override
    protected void checkCreateNew(TokenDataParams tokenDataParams) {
        TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)this.conversionHandler.convert(TokenPrincipalType.class, (Object)tokenDataParams.getType());
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)tokenDataParams.getUser());
        if (!this.hasPermissionToCreateNew(basicUser, tokenPrincipalType)) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected void customizeData(TokenData tokenData) {
        TokenDTO tokenDTO = (TokenDTO)tokenData.getDto();
        TokenPrincipalType tokenPrincipalType = this.find(TokenPrincipalType.class, tokenDTO.getType().getId());
        Token token = null;
        BasicUser basicUser = null;
        if (!tokenDTO.isTransient()) {
            token = this.find(Token.class, tokenDTO.getId());
            basicUser = token.getUser();
            tokenData.setCanBlock(tokenData.isCanBlock() && this.hasPermissionToBlock(token));
            tokenData.setCanCancel(tokenData.isCanCancel() && this.hasPermissionToCancel(token));
            tokenData.setCanChangeActivationDeadline(tokenData.isCanChangeActivationDeadline() && this.hasPermissionToChangeDates(token));
            tokenData.setCanChangeExpiryDate(tokenData.isCanChangeExpiryDate() && this.hasPermissionToChangeDates(token));
            tokenData.setCanUnblock(tokenData.isCanUnblock() && this.hasPermissionToUnblock(token));
        } else {
            basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)((TokenDTO)tokenData.getDto()).getUser());
        }
        tokenData.setCanActivate(tokenData.isCanActivate() && this.hasPermissionToActivate(basicUser, tokenPrincipalType, true));
        tokenData.setCanCreate(this.hasPermissionToCreateNew(basicUser, tokenPrincipalType));
    }

    @Override
    protected boolean doHasManageAccess(Token token) {
        return this.hasPermissionToCreateNew(null, token.getType()) || this.hasPermissionToChangeDates(token);
    }

    @Override
    protected CRUDServiceLocal<Token, TokenDTO, TokenData, TokenDataParams> getImplementation() {
        return this.tokenService;
    }

    @Override
    protected void onBeforeSave(TokenDTO tokenDTO, Token token) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)tokenDTO.getUser());
        if (!Objects.equals(basicUser, token.getUser())) {
            // empty if block
        }
        Date date = this.conversionHandler.toDate((IDate)tokenDTO.getExpiryDate());
        if (token.getExpiryDate() != null && !token.getExpiryDate().equals(date) && !this.hasPermissionToChangeDates(token)) {
            throw new PermissionDeniedException();
        }
        Date date2 = this.conversionHandler.toDate((IDate)tokenDTO.getActivationDeadline());
        if (token.getActivationDeadline() != null && !token.getActivationDeadline().equals(date2) && !this.hasPermissionToChangeDates(token)) {
            throw new PermissionDeniedException();
        }
    }

    private void cancel(Token token) {
        if (token == null) {
            throw new EntityNotFoundException(Token.class);
        }
        this.checkPermissionToCancel(token);
        this.tokenService.cancel(token);
    }

    private boolean canPersonalizeAsManager(NFCTokenPrincipalType nFCTokenPrincipalType, SessionData sessionData) {
        return sessionData.getProducts().userManagement().getUserTokenTypes().get((Object)nFCTokenPrincipalType).isSet((Path)QProductTokenType.productTokenType.personalize);
    }

    private boolean canPersonalizeAsMember(NFCTokenPrincipalType nFCTokenPrincipalType, SessionData sessionData) {
        return sessionData.getProducts().member().getActivateUserTokenTypes().contains(nFCTokenPrincipalType);
    }

    private boolean canViewTokenOwner(BasicUser basicUser) {
        SessionData sessionData = this.getSessionData();
        return basicUser == null || sessionData.getLoggedBasicUser().equals((Object)basicUser) || (!basicUser.isOperator() || this.operatorServiceSecurity.canViewOperators(basicUser.getUser())) && (basicUser.isOperator() || sessionData.isManagerOf((BasicUser)basicUser.getUser()));
    }

    private void checkPermissionToBlock(Token token) {
        if (!this.hasPermissionToBlock(token)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkPermissionToCancel(Token token) {
        if (!this.hasPermissionToCancel(token)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkPermissionToInitialize(NFCTokenPrincipalType nFCTokenPrincipalType) {
        if (!this.hasPermissionToInitialize(nFCTokenPrincipalType)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkPermissionToPersonalize(BasicUser basicUser, NFCTokenPrincipalType nFCTokenPrincipalType) {
        if (!this.hasPermissionToPersonalize(basicUser, nFCTokenPrincipalType)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkPermissionToPersonalizeAtRegistration(UserGroup userGroup, NFCTokenPrincipalType nFCTokenPrincipalType, boolean bl) {
        if (!this.hasPermissionToPersonalizeAtRegistration(userGroup, nFCTokenPrincipalType, bl)) {
            throw new PermissionDeniedException();
        }
    }

    private boolean checkQuery(TokenQuery tokenQuery) {
        Set set;
        TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)this.conversionHandler.convert(TokenPrincipalType.class, (Object)tokenQuery.getType());
        SessionData sessionData = this.getSessionData();
        if (sessionData.isBroker()) {
            tokenQuery.setGroups(null);
            tokenQuery.setBrokers(CollectionHelper.asSet((Object[])new UserVO[]{new UserVO(sessionData.getLoggedUser().getId())}));
        } else if (sessionData.isAdmin()) {
            set = this.groupsHandler.accessibles().groups().items();
            if (CollectionHelper.isEmpty((Iterable)set)) {
                return false;
            }
            Set set2 = this.groupsHandler.flattenVOs((Collection)tokenQuery.getGroups());
            set = PermissionHelper.applyAllowed((Collection)set2, (Collection)set);
            tokenQuery.setGroups(this.conversionHandler.convertSet(BasicGroupVO.class, (Iterable)set));
        } else {
            return false;
        }
        if (!this.hasPermissionToView(tokenPrincipalType)) {
            throw new PermissionDeniedException();
        }
        CollectionHelper.orEmpty((Set)tokenQuery.getBrokers()).forEach(iUser -> this.checkManagesUser((IUser)iUser));
        if (tokenQuery.getUser() != null) {
            set = (User)this.conversionHandler.convert(User.class, (Object)tokenQuery.getUser());
            this.checkManagesUser((BasicUser)set);
        }
        return true;
    }

    private ProductsAccessor getProductsAccessor(BasicUser basicUser) {
        return basicUser == null ? null : this.productsHandler.getAccessor(basicUser);
    }

    private boolean hasPermissionFor(Path<Boolean> path, Path<Boolean> path2, BasicUser basicUser, TokenPrincipalType tokenPrincipalType) {
        boolean bl;
        SessionData sessionData = this.getSessionData();
        this.checkLoggedIn();
        boolean bl2 = sessionData.getLoggedBasicUser().equals((Object)basicUser);
        boolean bl3 = bl = basicUser != null;
        if (bl2 || bl && sessionData.isOwnerOf(basicUser)) {
            return path != null && sessionData.getProducts().member().getMyTokenTypes().get((Object)tokenPrincipalType).isSet(path);
        }
        return (!bl ? sessionData.isUserManager() : sessionData.isManagerOf(basicUser)) && sessionData.getProducts().userManagement().getUserTokenTypes().get((Object)tokenPrincipalType).isSet(path2);
    }

    private boolean hasPermissionToActivate(BasicUser basicUser, TokenPrincipalType tokenPrincipalType, boolean bl) {
        SessionData sessionData = this.getSessionData();
        Supplier<Boolean> supplier = () -> sessionData.getProducts().member().getMyTokenTypes().get((Object)tokenPrincipalType).isSet((Path)QProductMyTokenType.productMyTokenType.activate);
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = basicUser == null ? sessionData.isUserManager() : sessionData.manages(basicUser);
            if (!bl2 || !this.isTokenPrincipalTypeEnabled(tokenPrincipalType, this.getProductsAccessor(basicUser))) {
                return false;
            }
            if (basicUser != null && sessionData.isOwnerOf(basicUser)) {
                return supplier.get();
            }
            return this.getProducts().userManagement().getUserTokenTypes().get((Object)tokenPrincipalType).isSet((Path)QProductTokenType.productTokenType.activate);
        }
        return (basicUser == null || sessionData.getLoggedBasicUser().equals((Object)basicUser)) && supplier.get() != false;
    }

    private boolean hasPermissionToAssign(Token token) {
        return this.hasPermissionFor(null, (Path<Boolean>)QProductUserTokenType.productUserTokenType.create, token.getUser(), token.getType());
    }

    private boolean hasPermissionToBlock(Token token) {
        return this.hasPermissionFor((Path<Boolean>)QProductMyTokenType.productMyTokenType.block, (Path<Boolean>)QProductTokenType.productTokenType.block, token.getUser(), token.getType());
    }

    private boolean hasPermissionToCancel(BasicUser basicUser, TokenPrincipalType tokenPrincipalType) {
        return this.hasPermissionFor((Path<Boolean>)QProductMyTokenType.productMyTokenType.cancel, (Path<Boolean>)QProductTokenType.productTokenType.cancel, basicUser, tokenPrincipalType);
    }

    private boolean hasPermissionToCancel(Token token) {
        TokenPrincipalType tokenPrincipalType = token.getType();
        return (!tokenPrincipalType.getTokenType().isNFCDevice() || this.getLoggedBasicUser().equals((Object)token.getUser())) && this.hasPermissionToCancel(token.getUser(), tokenPrincipalType);
    }

    private boolean hasPermissionToChangeDates(Token token) {
        return this.hasPermissionFor(null, (Path<Boolean>)QProductUserTokenType.productUserTokenType.changeDates, token.getUser(), token.getType());
    }

    private boolean hasPermissionToCreateNew(BasicUser basicUser, TokenPrincipalType tokenPrincipalType) {
        if (basicUser != null && !this.canManage(basicUser) || !this.isTokenPrincipalTypeEnabled(tokenPrincipalType, this.getProductsAccessor(basicUser))) {
            return false;
        }
        return this.hasPermissionFor(null, (Path<Boolean>)QProductUserTokenType.productUserTokenType.create, null, tokenPrincipalType);
    }

    private boolean hasPermissionToInitialize(NFCTokenPrincipalType nFCTokenPrincipalType) {
        return this.hasPermissionFor(null, (Path<Boolean>)QProductUserTokenType.productUserTokenType.initialize, null, (TokenPrincipalType)nFCTokenPrincipalType);
    }

    private boolean hasPermissionToPersonalize(BasicUser basicUser, NFCTokenPrincipalType nFCTokenPrincipalType) {
        SessionData sessionData = this.getSessionData();
        Supplier<Boolean> supplier = () -> sessionData.getProducts().member().getMyTokenTypes().get((Object)nFCTokenPrincipalType).isSet((Path)QProductTokenType.productTokenType.personalize);
        if (basicUser == null) {
            return sessionData.isUserManager() ? this.canPersonalizeAsManager(nFCTokenPrincipalType, sessionData) : this.canPersonalizeAsMember(nFCTokenPrincipalType, sessionData) || supplier.get() != false;
        }
        boolean bl = false;
        if (sessionData.manages(basicUser)) {
            bl = sessionData.isManagerOf(basicUser) ? this.canPersonalizeAsManager(nFCTokenPrincipalType, sessionData) : supplier.get().booleanValue();
        } else if (sessionData.relatesTo(basicUser)) {
            bl = this.canPersonalizeAsMember(nFCTokenPrincipalType, sessionData);
        }
        return bl && this.isTokenPrincipalTypeEnabled((TokenPrincipalType)nFCTokenPrincipalType, this.getProductsAccessor(basicUser));
    }

    private boolean hasPermissionToUnblock(Token token) {
        return this.hasPermissionFor((Path<Boolean>)QProductMyTokenType.productMyTokenType.unblock, (Path<Boolean>)QProductTokenType.productTokenType.unblock, token.getUser(), token.getType());
    }

    private boolean hasPermissionToView(TokenPrincipalType tokenPrincipalType) {
        return this.hasPermissionFor(null, (Path<Boolean>)QProductUserTokenType.productUserTokenType.view, null, tokenPrincipalType);
    }

    private boolean isTokenPrincipalTypeEnabled(TokenPrincipalType tokenPrincipalType, ProductsAccessor productsAccessor) {
        return productsAccessor == null || productsAccessor.member().getMyTokenTypes().get((Object)tokenPrincipalType).isSet((Path)QProductMyTokenType.productMyTokenType.enable);
    }
}

