/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import java.util.List;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.principaltypes.PrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.PrincipalTypeData;
import org.cyclos.model.access.principaltypes.PrincipalTypeNature;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.principaltypes.TokenPermissionsVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.Security;
import org.cyclos.security.SimpleConfigurationEntityCRUDServiceSecurity;
import org.cyclos.services.access.PrincipalTypeService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class PrincipalTypeServiceSecurity
extends SimpleConfigurationEntityCRUDServiceSecurity<PrincipalTypeDTO, PrincipalType, PrincipalTypeData, PrincipalTypeNature>
implements PrincipalTypeService {
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;

    public PrincipalTypeServiceSecurity() {
        super(PrincipalType.class, Permission.SYSTEM_CONFIGURATION_VIEW, Permission.SYSTEM_CONFIGURATION_MANAGE);
    }

    public List<PrincipalTypeVO> list() throws FrameworkException {
        this.checkViewPermission();
        return this.principalTypeService.list();
    }

    public List<TokenPermissionsVO> listUserTokenPermissions(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        this.checkManagesUser(basicUser);
        return this.principalTypeService.listUserTokenPermissions(basicUser);
    }

    @Override
    protected CRUDServiceLocal<PrincipalType, PrincipalTypeDTO, PrincipalTypeData, PrincipalTypeNature> getImplementation() {
        return this.principalTypeService;
    }
}

