/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security;

import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityData;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.PermissionUserAccess;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;

public abstract class SimpleConfigurationEntityCRUDServiceSecurity<DTO extends EntityDTO, E extends ConfigurationEntity, D extends EntityData<DTO>, DP>
extends ConfigurationEntityCRUDServiceSecurity<DTO, E, D, DP> {
    protected final Permission viewPermission;
    protected final Permission managePermission;

    public SimpleConfigurationEntityCRUDServiceSecurity(Class<E> clazz, Permission permission, Permission permission2) {
        super(clazz);
        this.viewPermission = this.validate(permission);
        this.managePermission = this.validate(permission2);
    }

    @Override
    public final boolean doHasManageAccess(E e) {
        return this.hasManagePermission();
    }

    @Override
    public final boolean doHasViewAccess(E e) {
        return this.hasViewPermission();
    }

    @Override
    protected final void checkCreateNew(DP DP) {
        this.checkManagePermission();
    }

    protected final void checkManagePermission() throws PermissionDeniedException {
        if (!this.hasManagePermission()) {
            throw new PermissionDeniedException();
        }
    }

    protected final void checkViewPermission() throws PermissionDeniedException {
        if (!this.hasViewPermission()) {
            throw new PermissionDeniedException();
        }
    }

    protected final boolean hasManagePermission() {
        return this.managePermission == null ? true : this.hasPermission(this.managePermission);
    }

    protected final boolean hasViewPermission() {
        return this.viewPermission == null ? true : this.hasPermission(this.viewPermission);
    }

    private Permission validate(Permission permission) {
        if (permission != null && permission.getUserAccess() != PermissionUserAccess.NONE) {
            throw new IllegalArgumentException("SimpleCRUDServiceSecurity should only permissions with user access NONE, but attempted to use " + String.valueOf(permission) + " which has user access " + String.valueOf(permission.getUserAccess()));
        }
        return permission;
    }
}

