/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.GwtIncompatible;

public class StringHelper {
    public static final String NUMBERS = "0123456789";
    public static final String UPPERCASE_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LOWERCASE_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase();
    public static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" + LOWERCASE_LETTERS;
    public static final String ALPHANUMERIC = LETTERS + "0123456789";
    public static final String SPECIAL_CHARACTERS = "`@!\"#$%&'()*+,-./:;<=>?[\\]^_{}~";
    public static final String NBSP = "&nbsp;";
    private static final String DATE_FIELDS = "GyMwWDdFEaHkKhmsSzZ";
    public static final String MASKED_VALUE = "****";
    public static Function<String, String> HTML_ENTITIES_REMOVER;
    @GwtIncompatible
    public static final Pattern VARIABLE_PATTERN;
    @GwtIncompatible
    private static final Pattern ASCII_PATTERN;
    @GwtIncompatible
    private static final Pattern UNACCENT_PATTERN;
    @GwtIncompatible
    private static final Pattern NON_ALPHA_PATTERN;
    private static final int MASK_PLAIN_LENGTH = 3;
    private static final String[] EMPTY_STRING_ARRAY;
    public static Random random;
    public static final List<String> THYMELEAF_MARKERS;

    public static boolean anyLineMatches(String string, boolean bl, Predicate<String> predicate) {
        if ((string = StringHelper.trimToNull(string)) == null) {
            return false;
        }
        for (String string2 : StringHelper.split(string.replace('\r', '\n'), "\n")) {
            if ((string2 = StringHelper.trimToNull(string2)) == null || bl && string2.charAt(0) == '#' || !predicate.test(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean areAllBlanks(Object ... objectArray) {
        if (CollectionHelper.isEmpty(objectArray)) {
            return true;
        }
        for (Object object : objectArray) {
            if (!StringHelper.isNotBlank(object)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllNotBlanks(Object ... objectArray) {
        if (CollectionHelper.isEmpty(objectArray)) {
            return false;
        }
        for (Object object : objectArray) {
            if (!StringHelper.isBlank(object)) continue;
            return false;
        }
        return true;
    }

    public static boolean areNotAllBlanks(Object ... objectArray) {
        return !StringHelper.areAllBlanks(objectArray);
    }

    @GwtIncompatible
    public static String asciiOnly(String string) {
        if (string == null) {
            return null;
        }
        return ASCII_PATTERN.matcher(string).replaceAll("");
    }

    public static String camelize(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0) {
                stringBuilder.append(Character.toLowerCase(c));
                continue;
            }
            if (SPECIAL_CHARACTERS.indexOf(c) >= 0) {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            stringBuilder.append(Character.toLowerCase(c));
        }
        return stringBuilder.toString();
    }

    public static String camelizeAndCapitalizeFirst(String string) {
        return StringHelper.capitalizeFirst(StringHelper.camelize(string));
    }

    public static String capitalize(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    public static String capitalizeAndCamelize(String string) {
        string = StringHelper.camelize(string);
        return StringHelper.capitalize(string);
    }

    public static String capitalizeFirst(String string) {
        if (StringHelper.isBlank(string)) {
            return string;
        }
        if (string.length() == 1) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    @SafeVarargs
    public static String coalesce(String ... stringArray) {
        for (String string : stringArray) {
            if (!StringHelper.isNotBlank(string)) continue;
            return string;
        }
        return null;
    }

    public static boolean containsIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        int n2 = string.length() - n;
        for (int i = 0; i <= n2; ++i) {
            if (!string.regionMatches(true, i, string2, 0, n)) continue;
            return true;
        }
        return false;
    }

    public static String convertNewLineToBr(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("\n", "<br>");
        return string;
    }

    @GwtIncompatible
    public static Map<String, String> decodeQueryParameters(String string) {
        char c;
        char c2 = c = string == null ? (char)'\u0000' : string.charAt(0);
        if (c == '?' || c == ';' || c == '#') {
            string = string.substring(1);
        }
        if (StringHelper.isBlank(string)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string2 : StringHelper.split(string, "&")) {
            String string3;
            String string4;
            String string5;
            List<String> list = StringHelper.split(string2, "=");
            if (list.size() != 2 || (string5 = linkedHashMap.put(string4 = StringHelper.decodeURIComponent(list.get(0)), string3 = StringHelper.decodeURIComponent(list.get(1)))) == null) continue;
            linkedHashMap.put(string4, string5 + "," + string3);
        }
        return linkedHashMap;
    }

    @GwtIncompatible
    public static String decodeURIComponent(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String defaultValue(String string, String string2) {
        return StringHelper.isBlank(string) ? string2 : string;
    }

    public static String defaultValue(String string, Supplier<String> supplier) {
        return StringHelper.isBlank(string) ? supplier.get() : string;
    }

    public static String delimit(String string, String string2, int n) {
        int n2 = string.length() + string2.length() * (string.length() / n) + 1;
        String string3 = "";
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i = 0; i < string.length(); i += n) {
            stringBuilder.append(string3);
            string3 = string2;
            stringBuilder.append(string.substring(i, Math.min(i + n, string.length())));
        }
        return stringBuilder.toString();
    }

    public static String emptyIfNull(String string) {
        return string == null ? "" : string;
    }

    @GwtIncompatible
    public static String encodeURIComponent(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static void forEachLine(String string2, boolean bl, Consumer<String> consumer) {
        StringHelper.forEachLine(string2, bl, (String string) -> {
            consumer.accept((String)string);
            return true;
        });
    }

    public static void forEachLine(String string, boolean bl, Predicate<String> predicate) {
        if ((string = StringHelper.trimToNull(string)) == null) {
            return;
        }
        for (String string2 : StringHelper.split(string.replace('\r', '\n'), "\n")) {
            if ((string2 = StringHelper.trimToNull(string2)) == null || bl && string2.charAt(0) == '#' || predicate.test(string2)) continue;
            return;
        }
    }

    public static String formatNumber(String string, String object, boolean bl) {
        int n;
        if (object == null) {
            return null;
        }
        if (StringHelper.isBlank(string)) {
            return object;
        }
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n != 35) continue;
            ++n2;
        }
        if (bl && n2 > ((String)object).length()) {
            object = StringHelper.repeat("0", n2 - ((String)object).length()) + (String)object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        n = string.length() - 1;
        for (int i = ((String)object).length() - 1; i >= 0; --i) {
            if (n >= 0) {
                char c = string.charAt(n);
                if (c == '#') {
                    stringBuilder.insert(0, ((String)object).charAt(i));
                } else {
                    stringBuilder.insert(0, c);
                    ++i;
                }
                --n;
                continue;
            }
            stringBuilder.insert(0, ((String)object).substring(0, i + 1));
            break;
        }
        return stringBuilder.toString();
    }

    public static String getNumberGenerationPattern(String string, Integer n, String string2) {
        if (n == null || n <= 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringHelper.processTxNumPart(string));
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('#');
        }
        stringBuilder.append(StringHelper.processTxNumPart(string2));
        return stringBuilder.toString();
    }

    @GwtIncompatible
    public static boolean hasVariables(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = VARIABLE_PATTERN.matcher(string);
        return matcher.find();
    }

    public static String htmlSpace() {
        return StringHelper.htmlSpaces(1);
    }

    public static String htmlSpaces(int n) {
        if (n < 0) {
            return "";
        }
        if (n == 1) {
            return NBSP;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(NBSP);
        }
        return stringBuilder.toString();
    }

    public static int indexOf(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return -1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if ((string != null || string2 != null) && (string == null || !string.equals(string2))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfAny(String string, String string2) {
        return StringHelper.indexOfAny(string, string2, 0);
    }

    public static int indexOfAny(String string, String string2, int n) {
        if (string == null || string2 == null || string2.isEmpty()) {
            return -1;
        }
        int n2 = string2.length();
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < n2; ++i) {
            int n4 = string.indexOf(string2.charAt(i), n);
            if (n4 < 0 || n4 >= n3) continue;
            n3 = n4;
        }
        return n3 == Integer.MAX_VALUE ? -1 : n3;
    }

    public static boolean isBlank(Object object) {
        return StringHelper.trimToNull(object) == null;
    }

    public static boolean isNotBlank(Object object) {
        return !StringHelper.isBlank(object);
    }

    public static boolean isNumeric(String string) {
        if (StringHelper.isBlank(string)) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (NUMBERS.indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isThymeleaf(String string) {
        return string != null && THYMELEAF_MARKERS.stream().anyMatch(string2 -> string.contains((CharSequence)string2));
    }

    public static String join(Collection<?> collection, String string) {
        return StringHelper.doJoin(collection, string, false);
    }

    public static String join(Object[] objectArray, String string) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return "";
        }
        return StringHelper.join(Arrays.asList(objectArray), string);
    }

    public static String joinTrimming(Collection<?> collection, String string) {
        return StringHelper.doJoin(collection, string, true);
    }

    public static String leftPad(String string, int n, char c) {
        if (string == null) {
            return null;
        }
        int n2 = n - string.length();
        if (n2 > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(c);
            }
            string = stringBuffer.append(string).toString();
        }
        return string;
    }

    public static String lowercaseFirst(String string) {
        if (StringHelper.isBlank(string)) {
            return string;
        }
        if (string.length() == 0) {
            return string.toLowerCase();
        }
        return String.valueOf(string.charAt(0)).toLowerCase() + string.substring(1);
    }

    public static String maskDigits(String string, int n) {
        int n2;
        int n3 = n2 = string == null ? 0 : string.length();
        if (n2 <= n) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c < '0' || c > '9') continue;
            arrayList.add(i);
        }
        if (arrayList.size() <= n) {
            return string;
        }
        List list = arrayList.subList(arrayList.size() - n, arrayList.size());
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (arrayList.contains(i) && !list.contains(i)) {
                stringBuilder.append('*');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String maskEmail(String string) {
        int n;
        int n2 = n = string == null ? -1 : string.indexOf(64);
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        if (string2.length() <= 3) {
            return StringHelper.repeat("*", string2.length()) + string.substring(n);
        }
        return string2.substring(0, 3) + StringHelper.repeat("*", string2.length() - 3) + string.substring(n);
    }

    public static String maskPhone(String string) {
        return StringHelper.maskDigits(string, 3);
    }

    public static String numbersOnly(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (NUMBERS.indexOf(c) < 0) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean phoneNumbersMatch(String string, String string2) {
        return StringHelper.suffixesEqual(StringHelper.numbersOnly(string), StringHelper.numbersOnly(string2), 7);
    }

    public static String random(String string, int n) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string.charAt(random.nextInt(n2)));
        }
        return stringBuilder.toString();
    }

    public static String randomAlphabetic(int n) {
        return StringHelper.random(LETTERS, n);
    }

    public static String randomAlphanumeric(int n) {
        return StringHelper.random(ALPHANUMERIC, n);
    }

    public static String randomNumeric(int n) {
        return StringHelper.random(NUMBERS, n);
    }

    public static String removeEnd(String string, String string2) {
        if (string == null || string2 == null || string2.isEmpty()) {
            return string;
        }
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String removeMarkupTags(String string) {
        return StringHelper.removeMarkupTags(string, true);
    }

    public static String removeMarkupTags(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (bl) {
            string = string.replace("\n", " ");
        }
        if (HTML_ENTITIES_REMOVER != null) {
            string = HTML_ENTITIES_REMOVER.apply(string);
        }
        string = string.replaceAll("<\\s?(br|BR|\\/p|\\/P|\\/div|\\/DIV)>", "\n");
        string = string.replace(NBSP, " ");
        return string.replaceAll("<\\/?[^>]+>", "");
    }

    @GwtIncompatible
    public static String removeNonAlpha(String string) {
        if (string == null) {
            return null;
        }
        return NON_ALPHA_PATTERN.matcher(string).replaceAll("");
    }

    public static String removeScripts(String object) {
        int n;
        if (object == null) {
            return null;
        }
        do {
            String string;
            if ((n = (string = ((String)object).toLowerCase()).indexOf("<script>")) < 0) continue;
            int n2 = string.indexOf("</script>");
            n2 = n2 < 0 ? ((String)object).length() : (n2 += "</script>".length());
            object = ((String)object).substring(0, n) + ((String)object).substring(n2);
        } while (n >= 0);
        return object;
    }

    public static String removeStart(String string, String string2) {
        if (string == null || string2 == null || string2.isEmpty()) {
            return string;
        }
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String repeat(String string, int n) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String replace(String string, String string2, String string3) {
        return StringHelper.replace(string, string2, string3, -1);
    }

    public static String replace(String string, String string2, String string3, int n) {
        if (StringHelper.isBlank(string) || StringHelper.isBlank(string2) || string3 == null || n == 0) {
            return string;
        }
        int n2 = 0;
        int n3 = string.indexOf(string2, n2);
        if (n3 == -1) {
            return string;
        }
        int n4 = string2.length();
        int n5 = string3.length() - n4;
        int n6 = n5 = n5 < 0 ? 0 : n5;
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n5 *= n < 0 ? 16 : (n > 64 ? 64 : n)));
        while (n3 != -1) {
            stringBuilder.append(string.substring(n2, n3)).append(string3);
            n2 = n3 + n4;
            if (--n == 0) break;
            n3 = string.indexOf(string2, n2);
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    public static String replacePeriod(String string) {
        return string == null ? null : string.replace('.', '\u2024');
    }

    @GwtIncompatible
    public static String replaceVariables(String string, boolean bl, Function<String, ?> function) {
        if (string == null) {
            return null;
        }
        Matcher matcher = VARIABLE_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            Object var6_6;
            String string2 = matcher.group(1);
            Object v0 = var6_6 = function == null ? null : function.apply(string2);
            if (var6_6 == null && bl) continue;
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(StringHelper.trim(var6_6)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    @GwtIncompatible
    public static String replaceVariables(String string, Function<String, ?> function) {
        return StringHelper.replaceVariables(string, false, function);
    }

    @GwtIncompatible
    public static String replaceVariables(String string, Map<String, ?> map) {
        if (string == null) {
            return null;
        }
        Matcher matcher = VARIABLE_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = StringHelper.trim(map.get(string2));
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string3));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String right(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() < n) {
            return "";
        }
        return string.substring(string.length() - n);
    }

    public static String safeFilename(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '-' && SPECIAL_CHARACTERS.indexOf(c) >= 0) {
                if (stringBuilder.charAt(stringBuilder.length() - 1) == '_') continue;
                stringBuilder.append('_');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static float score(String string, List<String> list, Function<String, String> function) {
        if (CollectionHelper.isEmpty(list)) {
            return 0.0f;
        }
        if ((string = StringHelper.trimToNull(string)) == null) {
            return 0.1f;
        }
        int n = list.size();
        for (String string2 : list) {
            String string3;
            String string4 = string3 = function == null ? string2 : function.apply(string2);
            if (string3 != null && StringHelper.containsIgnoreCase(string2, string)) break;
            --n;
        }
        return n;
    }

    public static void shuffle(StringBuilder stringBuilder, Random random) {
        int n = stringBuilder.length();
        for (int i = 0; i < n; ++i) {
            int n2 = random.nextInt(n);
            char c = stringBuilder.charAt(i);
            stringBuilder.setCharAt(i, stringBuilder.charAt(n2));
            stringBuilder.setCharAt(n2, c);
        }
    }

    public static List<String> split(String string, String string2) {
        int n;
        if (string == null) {
            return Collections.emptyList();
        }
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n = string.indexOf(string2, n2)) != -1) {
            if (n2 == n) {
                ++n2;
                continue;
            }
            arrayList.add(string.substring(n2, n));
            n2 = n + 1;
        }
        if (n2 < string.length()) {
            arrayList.add(string.substring(n2));
        }
        return arrayList;
    }

    public static String[] splitByLength(String string, int n) {
        if (StringHelper.isBlank(string)) {
            return EMPTY_STRING_ARRAY;
        }
        if (n <= 0) {
            throw new IllegalArgumentException("The max length must be greater than 0");
        }
        if (n >= string.length()) {
            return new String[]{string};
        }
        if (n == 1) {
            char[] cArray = string.toCharArray();
            String[] stringArray = new String[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                stringArray[i] = String.valueOf(cArray[i]);
            }
            return stringArray;
        }
        String[] stringArray = new String[(int)Math.ceil((double)string.length() / (double)n)];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string.substring(i * n, Math.min(string.length(), (i + 1) * n));
        }
        return stringArray;
    }

    public static String[] splitPreserveAllTokens(String string, String string2) {
        return StringHelper.splitWorker(string, string2, -1, true);
    }

    public static List<String> splitTrimming(String string, String string2) {
        if (StringHelper.isBlank(string)) {
            return Collections.emptyList();
        }
        List<String> list = StringHelper.split(string, string2);
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string3 = StringHelper.trimToNull(listIterator.next());
            if (string3 == null) {
                listIterator.remove();
                continue;
            }
            listIterator.set(string3);
        }
        return list;
    }

    public static boolean suffixesEqual(String string, String string2, int n) {
        if (string == null || string.length() < n || string2 == null || string2.length() < n) {
            return false;
        }
        return StringHelper.right(string, n).equals(StringHelper.right(string2, n));
    }

    public static SortedSet<Long> toLongSet(String string) {
        return StringHelper.splitTrimming(string, ",").stream().map(Long::valueOf).collect(Collectors.toCollection(TreeSet::new));
    }

    public static String transformCase(String string, boolean bl, char c) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (i > 0 && Character.isUpperCase(c2)) {
                stringBuilder.append(c);
            }
            stringBuilder.append(bl ? Character.toUpperCase(c2) : Character.toLowerCase(c2));
        }
        return stringBuilder.toString();
    }

    public static String trim(Object object) {
        try {
            return object == null ? "" : object.toString().trim();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String trimToNull(Object object) {
        String string = StringHelper.trim(object);
        return string.length() == 0 ? null : string;
    }

    public static String truncate(String object, int n) {
        if (object == null) {
            return null;
        }
        object = StringHelper.replace((String)object, "\r\n", " ");
        object = StringHelper.replace((String)object, "\n", " ");
        object = StringHelper.replace((String)object, "\r", " ");
        if (((String)(object = StringHelper.replace((String)object, "  ", " "))).length() < n || n < 0) {
            if (!((String)object).contains(" ") && ((String)object).length() > 50) {
                object = ((String)object).substring(0, 50) + "\u2026";
            }
            return object;
        }
        int n2 = n;
        if (((String)object).length() > n2) {
            int n3 = n2 - 1;
            for (int i = 0; i < 10; ++i) {
                try {
                    char c = ((String)object).charAt(n3 - i);
                    if (" \t\n\r.,()!?".indexOf(c) < 0) continue;
                    throw new Exception();
                }
                catch (Exception exception) {
                    n3 -= i;
                    break;
                }
            }
            object = n3 <= 0 ? ((String)object).substring(0, n) : ((String)object).substring(0, n3).trim() + "\u2026";
        }
        if (!((String)object).contains(" ") && ((String)object).length() > 50) {
            object = ((String)object).substring(0, 50) + "\u2026";
        }
        return object;
    }

    public static String truncateLines(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        string = StringHelper.replace(string, "\r\n", "\n".replace('\r', '\n'));
        List<String> list = StringHelper.split(string, "\n");
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (String string2 : list) {
            if (n3 >= n) break;
            if ((string2 = StringHelper.trimToNull(string2)) == null) continue;
            if (n3 > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(StringHelper.truncate(string2, n2));
            ++n3;
        }
        return stringBuilder.toString();
    }

    @GwtIncompatible
    public static String unaccent(String string) {
        if (string == null) {
            return null;
        }
        String string2 = Normalizer.normalize(string, Normalizer.Form.NFD);
        return UNACCENT_PATTERN.matcher(string2).replaceAll("");
    }

    public static native String unaccentGwt(String var0);

    public static String uncapitalizeFirst(String string) {
        if (StringHelper.isBlank(string)) {
            return string;
        }
        if (string.length() == 1) {
            return string.toLowerCase();
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    @GwtIncompatible
    public static String urlEncode(Map<String, ?> map) {
        if (CollectionHelper.isEmpty(map)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (CollectionHelper.isNotEmpty(map)) {
            map.forEach((string, object) -> {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(StringHelper.encodeURIComponent(string)).append('=');
                if (object != null) {
                    stringBuilder.append(StringHelper.encodeURIComponent(object.toString()));
                }
            });
        }
        return stringBuilder.toString();
    }

    public static String wrap(String string, int n) {
        String string2 = "\n";
        Object[] objectArray = StringHelper.splitPreserveAllTokens(string, string2);
        if (CollectionHelper.isEmpty(objectArray)) {
            return string;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = StringHelper.wrap((String)objectArray[i], n, string2, false);
        }
        return StringHelper.join(objectArray, string2);
    }

    private static String doJoin(Collection<?> collection, String string, boolean bl) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : collection) {
            if (bl && (object = StringHelper.trimToNull(object)) == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    private static String processDate(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (DATE_FIELDS.indexOf(c) >= 0) {
                stringBuilder.append('#');
                continue;
            }
            stringBuilder.append('\\').append(c);
        }
        return stringBuilder.toString();
    }

    private static String processTxNumPart(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = string == null ? 0 : string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '#') {
                if (bl) {
                    stringBuilder.append(StringHelper.processDate(stringBuilder2.toString()));
                    stringBuilder2.setLength(0);
                }
                bl = !bl;
                continue;
            }
            if (bl) {
                stringBuilder2.append(c);
                continue;
            }
            stringBuilder.append('\\').append(c);
        }
        return stringBuilder.toString();
    }

    private static String[] splitWorker(String string, String string2, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string2 == null) {
            while (n4 < n2) {
                if (Character.isWhitespace(string.charAt(n4))) {
                    if (bl2 || bl) {
                        bl3 = true;
                        if (n3++ == n) {
                            n4 = n2;
                            bl3 = false;
                        }
                        arrayList.add(string.substring(n5, n4));
                        bl2 = false;
                    }
                    n5 = ++n4;
                    continue;
                }
                bl3 = false;
                bl2 = true;
                ++n4;
            }
        } else if (string2.length() == 1) {
            char c = string2.charAt(0);
            while (n4 < n2) {
                if (string.charAt(n4) == c) {
                    if (bl2 || bl) {
                        bl3 = true;
                        if (n3++ == n) {
                            n4 = n2;
                            bl3 = false;
                        }
                        arrayList.add(string.substring(n5, n4));
                        bl2 = false;
                    }
                    n5 = ++n4;
                    continue;
                }
                bl3 = false;
                bl2 = true;
                ++n4;
            }
        } else {
            while (n4 < n2) {
                if (string2.indexOf(string.charAt(n4)) >= 0) {
                    if (bl2 || bl) {
                        bl3 = true;
                        if (n3++ == n) {
                            n4 = n2;
                            bl3 = false;
                        }
                        arrayList.add(string.substring(n5, n4));
                        bl2 = false;
                    }
                    n5 = ++n4;
                    continue;
                }
                bl3 = false;
                bl2 = true;
                ++n4;
            }
        }
        if (bl2 || bl && bl3) {
            arrayList.add(string.substring(n5, n4));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String wrap(String string, int n, String string2, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "\n";
        }
        if (n < 1) {
            n = 1;
        }
        int n2 = string.length();
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder(n2 + 32);
        while (n3 < n2) {
            if (string.charAt(n3) == ' ') {
                ++n3;
                continue;
            }
            if (n2 - n3 <= n) break;
            int n4 = string.lastIndexOf(32, n + n3);
            if (n4 >= n3) {
                stringBuilder.append(string.substring(n3, n4));
                stringBuilder.append(string2);
                n3 = n4 + 1;
                continue;
            }
            if (bl) {
                stringBuilder.append(string.substring(n3, n + n3));
                stringBuilder.append(string2);
                n3 += n;
                continue;
            }
            n4 = string.indexOf(32, n + n3);
            if (n4 >= 0) {
                stringBuilder.append(string.substring(n3, n4));
                stringBuilder.append(string2);
                n3 = n4 + 1;
                continue;
            }
            stringBuilder.append(string.substring(n3));
            n3 = n2;
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    static {
        VARIABLE_PATTERN = Pattern.compile("\\$?\\{([\\w\\.\\-]+)\\}");
        ASCII_PATTERN = Pattern.compile("\\P{InBasic_Latin}");
        UNACCENT_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        NON_ALPHA_PATTERN = Pattern.compile("[^\\p{L}\\d]");
        EMPTY_STRING_ARRAY = new String[0];
        random = new Random();
        THYMELEAF_MARKERS = Arrays.asList(" th:", "<th:block", " data-th-", "<th-block");
    }
}

