/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cyclos.utils.Page;

public class PageImpl<T>
implements Page<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<T> pageItems;
    private int currentPage;
    private int pageSize;
    private Integer totalCount;
    private boolean hasNextPage;
    private boolean partialData;

    public static <T> Page<T> empty() {
        return PageImpl.empty(0, 0);
    }

    public static <T> Page<T> empty(int n, int n2) {
        return new PageImpl(Collections.emptyList(), n, n2, 0, false);
    }

    public static <I, T> Page<T> page(T t) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.add(t);
        PageImpl<T> pageImpl = new PageImpl<T>();
        pageImpl.setPageItems(arrayList);
        pageImpl.setCurrentPage(0);
        pageImpl.setPageSize(1);
        pageImpl.setTotalCount(1);
        return pageImpl;
    }

    public static <I, T> Page<T> transformed(Page<I> page, Function<? super I, T> function) {
        PageImpl pageImpl = new PageImpl();
        pageImpl.setPageItems(page.stream().map(function).collect(Collectors.toList()));
        pageImpl.setCurrentPage(page.getCurrentPage());
        pageImpl.setPageSize(page.getPageSize());
        pageImpl.setTotalCount(page.getTotalCount());
        pageImpl.setHasNextPage(page.isHasNextPage());
        pageImpl.setPartialData(page.isPartialData());
        return pageImpl;
    }

    public static <T> Page<T> withNextPage(List<T> list, int n, int n2, boolean bl) {
        return new PageImpl<T>(list, n, n2, null, bl);
    }

    public static <T> Page<T> withTotalCount(List<T> list, int n, int n2, int n3) {
        boolean bl = PageImpl.getPageCount(n2, n) > n3 + 1;
        return new PageImpl<T>(list, n2, n3, n, bl);
    }

    private static int getPageCount(int n, int n2) {
        return n == 0 ? 0 : (int)Math.ceil((double)n2 / (double)n);
    }

    public PageImpl(List<T> list, int n, int n2, Integer n3, boolean bl) {
        this(list, n, n2, n3, bl, false);
    }

    public PageImpl(List<T> list, int n, int n2, Integer n3, boolean bl, boolean bl2) {
        this.setPageItems(list);
        this.setPageSize(n);
        this.setCurrentPage(n2);
        this.setTotalCount(n3);
        this.setHasNextPage(bl);
        this.setPartialData(bl2);
    }

    public PageImpl(Page<T> page) {
        this.setPageItems(page.getPageItems());
        this.setPageSize(page.getPageSize());
        this.setCurrentPage(page.getCurrentPage());
        this.setTotalCount(page.getTotalCount());
        this.setHasNextPage(page.isHasNextPage());
        this.setPartialData(page.isPartialData());
    }

    protected PageImpl() {
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public Integer getPageCount() {
        return this.totalCount == null ? null : Integer.valueOf(PageImpl.getPageCount(this.pageSize, this.totalCount));
    }

    @Override
    public List<T> getPageItems() {
        return this.pageItems;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public Integer getTotalCount() {
        return this.totalCount;
    }

    @Override
    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    @Override
    public boolean isPartialData() {
        return this.partialData;
    }

    @Override
    public Iterator<T> iterator() {
        return this.pageItems == null ? Collections.emptyList().iterator() : this.pageItems.iterator();
    }

    public void setCurrentPage(int n) {
        Integer n2 = this.getPageCount();
        this.currentPage = n2 == null ? n : Math.min(n, n2);
    }

    public void setHasNextPage(boolean bl) {
        this.hasNextPage = bl;
    }

    public void setPageItems(List<T> list) {
        this.pageItems = list;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public void setPartialData(boolean bl) {
        this.partialData = bl;
    }

    public void setTotalCount(Integer n) {
        this.totalCount = n;
    }

    @Override
    public Stream<T> stream() {
        return this.pageItems == null ? Collections.emptyList().stream() : this.pageItems.stream();
    }

    public String toString() {
        return "Page<currentPage=" + this.currentPage + ",pageSize=" + this.pageSize + ",totalCount=" + this.totalCount + ",pageItems=" + String.valueOf(this.pageItems) + ">";
    }
}

