/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.util.HashMap;
import java.util.Map;
import org.cyclos.model.Submodules;
import org.cyclos.utils.Module;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.Submodule;

public class ModelNameHelper {
    public static final String PACKAGE_ROOT = "org.cyclos.model";
    public static final String UTILS_PACKAGE_ROOT = "org.cyclos.model.utils";
    private static Map<Module, String> modulePackages;
    private static Map<Module, Map<Submodule, String>> submodulePackages;

    public static Module getModule(String string) {
        if (!ModelNameHelper.isModel(string)) {
            return null;
        }
        for (Map.Entry<Module, String> entry : ModelNameHelper.modulePackages().entrySet()) {
            if (!string.startsWith(entry.getValue() + ".")) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getPackageRoot(Module module) {
        if (module == null) {
            return null;
        }
        return "org.cyclos.model." + ModelNameHelper.packagePart(module.name());
    }

    public static String getPackageRoot(Submodule submodule) {
        if (submodule == null) {
            return null;
        }
        return ModelNameHelper.getPackageRoot(submodule.module()) + "." + ModelNameHelper.packagePart(submodule.name());
    }

    public static Submodule getSubmodule(String string) {
        Module module = ModelNameHelper.getModule(string);
        if (module == null) {
            return null;
        }
        for (Map.Entry<Submodule, String> entry : ModelNameHelper.submodulePackages(module).entrySet()) {
            if (!string.startsWith(entry.getValue() + ".")) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean isModel(String string) {
        return string != null && string.startsWith(PACKAGE_ROOT);
    }

    public static boolean isModelUtils(String string) {
        return string != null && string.startsWith(UTILS_PACKAGE_ROOT);
    }

    public static String qualify(Module module, String ... stringArray) {
        String string = StringHelper.join(stringArray, "");
        return module == null ? string : ModelNameHelper.getPackageRoot(module) + "." + string;
    }

    public static String qualify(String ... stringArray) {
        String string = StringHelper.join(stringArray, "");
        return "org.cyclos.model." + string;
    }

    public static String qualify(Submodule submodule, String ... stringArray) {
        String string = StringHelper.join(stringArray, "");
        return submodule == null ? string : ModelNameHelper.getPackageRoot(submodule) + "." + string;
    }

    public static String qualifyUtils(String ... stringArray) {
        String string = StringHelper.join(stringArray, "");
        return "org.cyclos.model.utils." + string;
    }

    private static synchronized Map<Module, String> modulePackages() {
        if (modulePackages == null) {
            HashMap<Module, String> hashMap = new HashMap<Module, String>();
            for (Module module : Module.values()) {
                hashMap.put(module, ModelNameHelper.getPackageRoot(module));
            }
            modulePackages = hashMap;
        }
        return modulePackages;
    }

    private static String packagePart(String string) {
        return StringHelper.replace(string.toLowerCase(), "_", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Submodule, String> submodulePackages(Module module) {
        Map<Submodule, String> map = submodulePackages.get((Object)module);
        if (map == null) {
            Map<Module, Map<Submodule, String>> map2 = submodulePackages;
            synchronized (map2) {
                map = submodulePackages.get((Object)module);
                if (map == null) {
                    map = new HashMap<Submodule, String>();
                    for (Submodule submodule : Submodules.getSubmodulesFromModule(module)) {
                        map.put(submodule, ModelNameHelper.getPackageRoot(submodule));
                    }
                    submodulePackages.put(module, map);
                }
            }
        }
        return map;
    }

    static {
        submodulePackages = new HashMap<Module, Map<Submodule, String>>();
    }
}

