/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cyclos.model.access.identityproviders.IdentityProviderCallbackResult;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.fields.UserCustomFieldDetailedVO;
import org.cyclos.model.users.fields.UserCustomFieldValueDTO;
import org.cyclos.model.users.phones.LandLinePhoneDTO;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.phones.PhoneDTO;
import org.cyclos.model.users.products.UserCustomFieldActions;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.users.users.PublicRegistrationData;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;

public class PublicRegistrationHelper {
    public static void fillFromIdentityProvider(PublicRegistrationData publicRegistrationData, IdentityProviderCallbackResult identityProviderCallbackResult) {
        Object object;
        Object object2;
        Object object3;
        String string3;
        String string4;
        String string5;
        PublicRegistrationDTO publicRegistrationDTO = (PublicRegistrationDTO)publicRegistrationData.getDto();
        publicRegistrationDTO.setIdentityProviderRequestId(identityProviderCallbackResult.getRequestId());
        String string6 = StringHelper.trimToNull((Object)identityProviderCallbackResult.getName());
        if (string6 != null) {
            publicRegistrationDTO.setName(string6);
        }
        if ((string5 = StringHelper.trimToNull((Object)identityProviderCallbackResult.getUsername())) != null) {
            publicRegistrationDTO.setUsername(string5);
        }
        if ((string4 = StringHelper.trimToNull((Object)identityProviderCallbackResult.getEmail())) != null) {
            publicRegistrationDTO.setEmail(string4);
        }
        if ((string3 = StringHelper.trimToNull((Object)identityProviderCallbackResult.getMobilePhone())) != null) {
            object3 = new MobilePhoneDTO();
            ((PhoneDTO)((Object)object3)).setRawNumber(string3);
            publicRegistrationDTO.setMobilePhones(Arrays.asList(object3));
        }
        if ((object3 = StringHelper.trimToNull((Object)identityProviderCallbackResult.getLandLinePhone())) != null) {
            object2 = new LandLinePhoneDTO();
            ((PhoneDTO)((Object)object2)).setRawNumber((String)object3);
            ((LandLinePhoneDTO)((Object)object2)).setExtension(StringHelper.trimToNull((Object)identityProviderCallbackResult.getLandLineExtension()));
            publicRegistrationDTO.setLandLinePhones(Arrays.asList(object2));
        }
        if ((object2 = identityProviderCallbackResult.getImage()) != null) {
            object = new ArrayList();
            ((ArrayList)object).add(object2);
            publicRegistrationDTO.setUploadedImages((List<ImageVO>)object);
        }
        if (CollectionHelper.isNotEmpty((Map)(object = identityProviderCallbackResult.getCustomValues()))) {
            if (publicRegistrationDTO.getCustomValues() == null) {
                publicRegistrationDTO.setCustomValues((List<UserCustomFieldValueDTO>)new ArrayList<UserCustomFieldValueDTO>());
            }
            object.forEach((string, string2) -> {
                CustomFieldDetailedVO customFieldDetailedVO;
                if (string2 != null && (customFieldDetailedVO = (CustomFieldDetailedVO)CollectionHelper.orEmpty(publicRegistrationData.getProfileFieldActions()).stream().filter(userProfileFieldActions -> {
                    if (userProfileFieldActions instanceof UserCustomFieldActions) {
                        UserCustomFieldDetailedVO userCustomFieldDetailedVO = ((UserCustomFieldActions)((Object)((Object)userProfileFieldActions))).getCustomField();
                        return string.equals(userCustomFieldDetailedVO.getInternalName());
                    }
                    return false;
                }).map(userProfileFieldActions -> ((UserCustomFieldActions)((Object)((Object)userProfileFieldActions))).getCustomField()).findFirst().orElse(null)) != null) {
                    PublicRegistrationHelper.setCustomFieldValue(publicRegistrationDTO, customFieldDetailedVO, string2);
                }
            });
        }
    }

    private static void setCustomFieldValue(PublicRegistrationDTO publicRegistrationDTO, CustomFieldDetailedVO customFieldDetailedVO, String string) {
        UserCustomFieldValueDTO userCustomFieldValueDTO2 = publicRegistrationDTO.getCustomValues().stream().filter(userCustomFieldValueDTO -> userCustomFieldValueDTO.getField().equals(customFieldDetailedVO)).findFirst().orElse(null);
        if (userCustomFieldValueDTO2 == null) {
            userCustomFieldValueDTO2 = new UserCustomFieldValueDTO();
            userCustomFieldValueDTO2.setField(customFieldDetailedVO);
            publicRegistrationDTO.getCustomValues().add(userCustomFieldValueDTO2);
        }
        Object object = null;
        switch (customFieldDetailedVO.getType()) {
            case STRING: 
            case TEXT: 
            case RICH_TEXT: 
            case URL: {
                object = string;
                break;
            }
            case SINGLE_SELECTION: {
                object = CollectionHelper.orEmpty(customFieldDetailedVO.getPossibleValues()).stream().filter(customFieldPossibleValueVO -> string.equals(customFieldPossibleValueVO.getInternalName())).findFirst().orElse(null);
                break;
            }
            case DATE: {
                object = DateTime.parse((String)string);
                break;
            }
            case DECIMAL: {
                object = CoercionHelper.coerce(BigDecimal.class, (Object)string);
                break;
            }
            case INTEGER: {
                object = CoercionHelper.coerce(Integer.class, (Object)string);
                break;
            }
            case BOOLEAN: {
                object = CoercionHelper.coerce(Boolean.class, (Object)string);
                break;
            }
        }
        CustomFieldHelper.setCustomFieldValue(userCustomFieldValueDTO2, object);
    }
}

