/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.IteratorUtils;
import org.cyclos.utils.AbstractParameterStorage;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.ParameterStorage;
import org.cyclos.utils.StringHelper;

@GwtIncompatible
public class MapParameterStorage
extends AbstractParameterStorage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, ? extends Serializable> map;
    private final boolean caseInsensitive;

    public MapParameterStorage() {
        this(false);
    }

    public MapParameterStorage(boolean bl) {
        this.map = new HashMap<String, Serializable>();
        this.caseInsensitive = bl;
    }

    public MapParameterStorage(Map<String, ? extends Serializable> map) {
        this(map, false);
    }

    public MapParameterStorage(Map<String, ? extends Serializable> map, boolean bl) {
        this.map = map;
        this.caseInsensitive = bl;
    }

    public MapParameterStorage(ParameterStorage parameterStorage) {
        this(parameterStorage, parameterStorage instanceof MapParameterStorage ? ((MapParameterStorage)parameterStorage).caseInsensitive : false);
    }

    public MapParameterStorage(ParameterStorage parameterStorage, boolean bl) {
        this(bl);
        parameterStorage.getNames().forEachRemaining(string -> this.map.put((String)string, (Serializable)((Object)parameterStorage.getStringList((String)string))));
    }

    @Override
    public Iterator<String> getNames() {
        return this.map.keySet().iterator();
    }

    @Override
    public String getString(String string) {
        Iterator iterator = IteratorUtils.getIterator((Object)this.map.get(this.key(string)));
        if (!iterator.hasNext()) {
            return null;
        }
        Object e = iterator.next();
        return e == null ? null : e.toString();
    }

    @Override
    public List<String> getStringList(String string) {
        Iterator iterator = IteratorUtils.getIterator((Object)this.map.get(this.key(string)));
        ArrayList<String> arrayList = new ArrayList<String>();
        iterator.forEachRemaining(object -> {
            if (object != null) {
                arrayList.add(object.toString());
            }
        });
        return arrayList;
    }

    public Object propertyMissing(String string) {
        return this.getString(string);
    }

    public void propertyMissing(String string, Object object) {
        String string2 = StringHelper.trimToNull((Object)object);
        if (string2 == null) {
            this.remove(string);
        } else {
            this.setString(string, string2);
        }
    }

    @Override
    public void remove(String string) {
        this.map.remove(this.key(string));
    }

    @Override
    protected void doSet(String string, List<String> list) {
        this.map.put(this.key(string), (Serializable)((Object)list));
    }

    private String key(String string) {
        if (this.caseInsensitive && string != null) {
            return string.toLowerCase();
        }
        return string;
    }
}

