/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.io.Serializable;
import org.cyclos.utils.StringHelper;

public class HttpServiceInvocationData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String KEY = "httpServiceInvocationData";
    private AccessType accessType;
    private String principalType;
    private String principal;
    private String password;
    private String channel;
    private String sessionToken;
    private String remoteAddress;
    private String accessClientToken;
    private String accessToken;

    public static HttpServiceInvocationData accessClient(String string) {
        HttpServiceInvocationData httpServiceInvocationData = new HttpServiceInvocationData();
        httpServiceInvocationData.accessClientToken = string;
        httpServiceInvocationData.accessType = AccessType.ACCESS_CLIENT;
        return httpServiceInvocationData;
    }

    public static HttpServiceInvocationData oidc(String string) {
        HttpServiceInvocationData httpServiceInvocationData = new HttpServiceInvocationData();
        httpServiceInvocationData.accessToken = string;
        httpServiceInvocationData.accessType = AccessType.OIDC;
        return httpServiceInvocationData;
    }

    public static HttpServiceInvocationData stateful(String string) {
        return HttpServiceInvocationData.stateful(string, null);
    }

    public static HttpServiceInvocationData stateful(String string, String string2) {
        HttpServiceInvocationData httpServiceInvocationData = new HttpServiceInvocationData();
        httpServiceInvocationData.sessionToken = string;
        httpServiceInvocationData.remoteAddress = string2;
        httpServiceInvocationData.accessType = AccessType.SESSION;
        return httpServiceInvocationData;
    }

    public static HttpServiceInvocationData stateless(String string, String string2) {
        return HttpServiceInvocationData.stateless(null, string, string2);
    }

    public static HttpServiceInvocationData stateless(String string, String string2, String string3) {
        HttpServiceInvocationData httpServiceInvocationData = new HttpServiceInvocationData();
        httpServiceInvocationData.principalType = string;
        httpServiceInvocationData.principal = string2;
        httpServiceInvocationData.password = string3;
        httpServiceInvocationData.accessType = AccessType.LOGIN;
        return httpServiceInvocationData;
    }

    private HttpServiceInvocationData() {
    }

    public String getAccessClientToken() {
        return this.accessClientToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getPrincipalType() {
        return this.principalType;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public boolean isValid() {
        if (this.accessType != null) {
            switch (this.accessType.ordinal()) {
                case 0: {
                    return StringHelper.isNotBlank((Object)this.principal) && StringHelper.isNotBlank((Object)this.password);
                }
                case 1: {
                    return StringHelper.isNotBlank((Object)this.sessionToken);
                }
                case 2: {
                    return StringHelper.isNotBlank((Object)this.accessClientToken);
                }
                case 3: {
                    return StringHelper.isNotBlank((Object)this.accessToken);
                }
            }
        }
        return false;
    }

    public void setAccessToken(String string) {
        this.accessToken = string;
    }

    public void setChannel(String string) {
        this.channel = string;
    }

    public static enum AccessType {
        LOGIN,
        SESSION,
        ACCESS_CLIENT,
        OIDC;

    }
}

