/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cyclos.model.Property;
import org.cyclos.model.access.devices.DeviceConfirmationFeedbackPushNotificationData;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.access.identityproviders.IdentityProviderCallbackResult;
import org.cyclos.model.banking.accounts.AccountWithStatusVO;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.messaging.messages.NewMessagePushNotificationData;
import org.cyclos.model.messaging.notifications.NewNotificationPushNotificationData;
import org.cyclos.model.utils.PushNotificationEventFilter;

public class PushNotificationEventType<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, PushNotificationEventType<?>> NAME_MAP = new LinkedHashMap();
    public static final PushNotificationEventType<TicketVO> TICKET = new PushNotificationEventType<TicketVO>("ticket", true, PushNotificationEventFilter.TICKET_NUMBER, TicketVO.class, TicketVO.CLASS_NAME){
        private static final long serialVersionUID = 1L;
    };
    public static final PushNotificationEventType<DeviceConfirmationVO> DEVICE_CONFIRMATION = new PushNotificationEventType<DeviceConfirmationVO>("deviceConfirmation", false, PushNotificationEventFilter.DEVICE_CONFIRMATION_ID, DeviceConfirmationVO.class, DeviceConfirmationVO.CLASS_NAME){
        private static final long serialVersionUID = 1L;
    };
    public static final PushNotificationEventType<NewMessagePushNotificationData> NEW_MESSAGE = new PushNotificationEventType<NewMessagePushNotificationData>("newMessage", false, null, NewMessagePushNotificationData.class, NewMessagePushNotificationData.CLASS_NAME){
        private static final long serialVersionUID = 1L;
    };
    public static final PushNotificationEventType<NewNotificationPushNotificationData> NEW_NOTIFICATION = new PushNotificationEventType<NewNotificationPushNotificationData>("newNotification", false, null, NewNotificationPushNotificationData.class, NewNotificationPushNotificationData.CLASS_NAME){
        private static final long serialVersionUID = 1L;
    };
    public static final PushNotificationEventType<TransactionVO> PAYMENT_AUTHORIZATION = new PushNotificationEventType<TransactionVO>("paymentAuthorization", false, null, TransactionVO.class, TransactionVO.CLASS_NAME){
        private static final long serialVersionUID = 1L;
    };
    public static final PushNotificationEventType<DeviceConfirmationFeedbackPushNotificationData> DEVICE_CONFIRMATION_FEEDBACK = new PushNotificationEventType<DeviceConfirmationFeedbackPushNotificationData>("deviceConfirmationFeedback", true, PushNotificationEventFilter.DEVICE_CONFIRMATION_ID, DeviceConfirmationFeedbackPushNotificationData.class, DeviceConfirmationFeedbackPushNotificationData.CLASS_NAME){
        private static final long serialVersionUID = 1L;
    };
    public static final PushNotificationEventType<IdentityProviderCallbackResult> IDENTITY_PROVIDER_CALLBACK = new PushNotificationEventType<IdentityProviderCallbackResult>("identityProviderCallback", true, PushNotificationEventFilter.IDENTITY_PROVIDER_REQUEST_ID, IdentityProviderCallbackResult.class, IdentityProviderCallbackResult.CLASS_NAME){
        private static final long serialVersionUID = 1L;
    };
    public static final PushNotificationEventType<Void> LOGGED_OUT = new PushNotificationEventType<Void>("loggedOut", false, null, null, null){
        private static final long serialVersionUID = 1L;
    };
    public static final PushNotificationEventType<Void> PERMISSIONS_CHANGED = new PushNotificationEventType<Void>("permissionsChanged", false, null, null, null){
        private static final long serialVersionUID = 1L;
    };
    public static final PushNotificationEventType<AccountWithStatusVO> ACCOUNT_STATUS = new PushNotificationEventType<AccountWithStatusVO>("accountStatus", false, null, AccountWithStatusVO.class, AccountWithStatusVO.CLASS_NAME){
        private static final long serialVersionUID = 1L;
    };
    private final String name;
    private final boolean allowGuest;
    private final Property<?, PushNotificationEventFilter> filter;
    private final Class<T> dataType;
    private final String dataTypeName;

    public static List<PushNotificationEventType<?>> getAll() {
        return new ArrayList(NAME_MAP.values());
    }

    public static PushNotificationEventType<?> getByName(String string) {
        return NAME_MAP.get(string);
    }

    private PushNotificationEventType(String string, boolean bl, Property<?, PushNotificationEventFilter> property, Class<T> clazz, String string2) {
        this.name = string;
        this.allowGuest = bl;
        this.filter = property;
        this.dataType = clazz;
        this.dataTypeName = string2;
        NAME_MAP.put(string, this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PushNotificationEventType pushNotificationEventType = (PushNotificationEventType)object;
        return this.name.equals(pushNotificationEventType.name);
    }

    public Class<T> getDataType() {
        return this.dataType;
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public Property<?, PushNotificationEventFilter> getFilter() {
        return this.filter;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean isAllowGuest() {
        return this.allowGuest;
    }

    public String toString() {
        return this.name;
    }

    protected Object writeReplace() {
        return new SerializedForm(this.name);
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;

        public SerializedForm(String string) {
            this.name = string;
        }

        public Object readResolve() {
            return PushNotificationEventType.getByName(this.name);
        }
    }
}

