/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum DistanceUnit implements HasMessageKey
{
    KILOMETER,
    MILE;

    private static final double MILE_TO_KILOMETER = 1.60934;
    private static EnumMessageKeyResolver<DistanceUnit> resolverForDistanceWithUnit;
    private static EnumMessageKeyResolver<DistanceUnit> resolverForDistanceFrom;
    private static List<BigDecimal> kilometers;
    private static List<BigDecimal> miles;

    public static List<BigDecimal> getValues(DistanceUnit distanceUnit) {
        switch (distanceUnit.ordinal()) {
            case 0: {
                return kilometers;
            }
            case 1: {
                return miles;
            }
        }
        throw new IllegalArgumentException();
    }

    public static EnumMessageKeyResolver<DistanceUnit> resolverForDistanceFrom() {
        if (resolverForDistanceFrom == null) {
            resolverForDistanceFrom = distanceUnit -> {
                switch (distanceUnit.ordinal()) {
                    case 0: {
                        return GeneralKeys.Ui.DISTANCE_KILOMETER;
                    }
                    case 1: {
                        return GeneralKeys.Ui.DISTANCE_MILE;
                    }
                }
                return null;
            };
        }
        return resolverForDistanceFrom;
    }

    public static EnumMessageKeyResolver<DistanceUnit> resolverForDistanceWithUnit() {
        if (resolverForDistanceWithUnit == null) {
            resolverForDistanceWithUnit = distanceUnit -> {
                switch (distanceUnit.ordinal()) {
                    case 0: {
                        return GeneralKeys.Ui.DISTANCE_UNIT_KILOMETER;
                    }
                    case 1: {
                        return GeneralKeys.Ui.DISTANCE_UNIT_MILE;
                    }
                }
                return null;
            };
        }
        return resolverForDistanceWithUnit;
    }

    public double fromMeters(double d) {
        switch (this.ordinal()) {
            case 0: {
                return d / 1000.0;
            }
            case 1: {
                return d / 1000.0 / 1.60934;
            }
        }
        throw new IllegalArgumentException();
    }

    public BigDecimal getDefaultValue() {
        switch (this.ordinal()) {
            case 0: {
                return new BigDecimal(5);
            }
            case 1: {
                return new BigDecimal(3);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return SystemKeys.Languages.DISTANCE_UNIT_KILOMETER;
            }
            case 1: {
                return SystemKeys.Languages.DISTANCE_UNIT_MILE;
            }
        }
        return null;
    }

    public double toMeters(double d) {
        switch (this.ordinal()) {
            case 0: {
                return d * 1000.0;
            }
            case 1: {
                return d * 1000.0 * 1.60934;
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        kilometers = Arrays.asList(new BigDecimal(1), new BigDecimal(5), new BigDecimal(10), new BigDecimal(15), new BigDecimal(25), new BigDecimal(50), new BigDecimal(75), new BigDecimal(100));
        miles = Arrays.asList(new BigDecimal(1), new BigDecimal(3), new BigDecimal(6), new BigDecimal(10), new BigDecimal(15), new BigDecimal(30), new BigDecimal(45), new BigDecimal(60));
    }
}

