/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.function.Supplier;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.ExternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.currencies.ICurrency;
import org.cyclos.model.banking.rates.FormattableTimeBasedRate;
import org.cyclos.model.contentmanagement.IBinaryFile;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.system.fields.ICustomFieldPossibleValue;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.fields.ICustomFieldValueWithList;
import org.cyclos.model.system.fields.ICustomFieldValueWithSet;
import org.cyclos.model.system.fields.IDynamicFieldValue;
import org.cyclos.model.system.fields.LinkedEntityVO;
import org.cyclos.model.system.images.IImage;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FileSizeUnit;
import org.cyclos.model.utils.HasDisplay;
import org.cyclos.model.utils.ICurrencyAmount;
import org.cyclos.model.utils.ICurrencyAmountRange;
import org.cyclos.model.utils.IDatePeriod;
import org.cyclos.model.utils.IDecimalRange;
import org.cyclos.model.utils.IDimensions;
import org.cyclos.model.utils.IFileSize;
import org.cyclos.model.utils.ILatLong;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.Range;
import org.cyclos.model.utils.TimeField;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.Formatter;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.IDate;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.Percentage;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.TranslationMessageSpecification;

public abstract class AbstractFormatter
implements Formatter {
    protected static String TIMESTAMP_PATTERN = "HH:mm:ss.SSS";

    @Override
    public String format(AccountOwner accountOwner) {
        if (accountOwner == null) {
            return "";
        }
        if (accountOwner instanceof SystemAccountOwner) {
            return this.message(GeneralKeys.Ui.SYSTEM, new Object[0]);
        }
        if (accountOwner instanceof ExternalAccountOwner) {
            return this.message(GeneralKeys.Ui.EXTERNAL_USER, new Object[0]);
        }
        if (accountOwner instanceof BasicUserVO) {
            return ((BasicUserVO)accountOwner).getDisplay();
        }
        return this.format((Object)accountOwner);
    }

    @Override
    public String format(Boolean bl) {
        boolean bl2 = Boolean.TRUE.equals(bl);
        return this.message(bl2 ? GeneralKeys.Ui.YES : GeneralKeys.Ui.NO, new Object[0]);
    }

    @Override
    public String format(Collection<?> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        if (collection != null) {
            boolean bl = true;
            for (Object obj : collection) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.format(obj));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String format(FormattableTimeBasedRate formattableTimeBasedRate) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = bigDecimal = formattableTimeBasedRate == null ? null : formattableTimeBasedRate.getRate();
        if (bigDecimal == null) {
            return "";
        }
        Pair<BigDecimal, BigDecimal> pair = this.splitDecimal(bigDecimal);
        BigDecimal bigDecimal3 = ((BigDecimal)pair.getSecond()).multiply(new BigDecimal("24"));
        Pair<BigDecimal, BigDecimal> pair2 = this.splitDecimal(bigDecimal3);
        BigDecimal bigDecimal4 = ((BigDecimal)pair2.getSecond()).multiply(new BigDecimal("60"));
        Pair<BigDecimal, BigDecimal> pair3 = this.splitDecimal(bigDecimal4);
        BigDecimal bigDecimal5 = ((BigDecimal)pair3.getSecond()).multiply(new BigDecimal("60"));
        bigDecimal5 = bigDecimal5.setScale(0, RoundingMode.HALF_UP);
        BigDecimal bigDecimal6 = this.roundHour((BigDecimal)pair2.getFirst(), (BigDecimal)pair3.getFirst(), bigDecimal5);
        BigDecimal bigDecimal7 = (BigDecimal)pair.getFirst();
        if (BigDecimalHelper.areEquals((BigDecimal)bigDecimal6, (BigDecimal)new BigDecimal("24"))) {
            bigDecimal7 = bigDecimal7.add(BigDecimal.ONE);
            bigDecimal6 = BigDecimal.ZERO;
        }
        StringBuilder stringBuilder = new StringBuilder();
        MessageKey messageKey = formattableTimeBasedRate.getDaysKey();
        if (bigDecimal7.compareTo(BigDecimal.ONE) <= 0) {
            messageKey = formattableTimeBasedRate.getDayKey();
        }
        stringBuilder.append(bigDecimal7);
        stringBuilder.append(" ");
        stringBuilder.append(this.message(messageKey, new Object[0]));
        if (!BigDecimalHelper.isZero((BigDecimal)bigDecimal6)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" + ");
            }
            MessageKey messageKey2 = formattableTimeBasedRate.getHoursKey();
            if (bigDecimal6.compareTo(BigDecimal.ONE) == 0) {
                messageKey2 = formattableTimeBasedRate.getHourKey();
            }
            stringBuilder.append(bigDecimal6);
            stringBuilder.append(" ");
            stringBuilder.append(this.message(messageKey2, new Object[0]));
        }
        if (formattableTimeBasedRate.getExtraRemarkKey() != null) {
            stringBuilder.append(" ").append(this.message(formattableTimeBasedRate.getExtraRemarkKey(), new Object[0]));
        }
        return stringBuilder.toString();
    }

    @Override
    public String format(HasDisplay hasDisplay) {
        String string = hasDisplay == null ? null : hasDisplay.getDisplay();
        return StringHelper.trim((Object)string);
    }

    @Override
    public String format(HasMessageKey hasMessageKey) {
        if (hasMessageKey == null) {
            return "";
        }
        MessageKey messageKey = hasMessageKey.getMessageKey();
        return messageKey == null ? "???" + String.valueOf(hasMessageKey) + "???" : this.message(messageKey, new Object[0]);
    }

    @Override
    public String format(IBinaryFile iBinaryFile) {
        if (iBinaryFile == null) {
            return "";
        }
        return iBinaryFile.getName() + " (" + iBinaryFile.getContentType() + ", " + String.valueOf(FileSizeUnit.nearestFileSize(iBinaryFile.getLength())) + ")";
    }

    @Override
    public String format(ICurrency iCurrency, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return "";
        }
        if (iCurrency == null) {
            return this.format(bigDecimal);
        }
        return StringHelper.defaultValue((String)iCurrency.getPrefix(), (String)"") + this.format(bigDecimal, iCurrency.getPrecision()) + StringHelper.defaultValue((String)iCurrency.getSuffix(), (String)"");
    }

    @Override
    public String format(ICurrencyAmount iCurrencyAmount) {
        BigDecimal bigDecimal = iCurrencyAmount == null ? null : iCurrencyAmount.getAmount();
        ICurrency iCurrency = iCurrencyAmount == null ? null : iCurrencyAmount.getCurrency();
        return this.format(iCurrency, bigDecimal);
    }

    @Override
    public String format(ICurrencyAmountRange iCurrencyAmountRange) {
        if (iCurrencyAmountRange == null) {
            return "";
        }
        ICurrency iCurrency = iCurrencyAmountRange.getCurrency();
        BigDecimal bigDecimal = (BigDecimal)iCurrencyAmountRange.getMin();
        BigDecimal bigDecimal2 = (BigDecimal)iCurrencyAmountRange.getMax();
        return this.formatRange(this.format(iCurrency, bigDecimal), this.format(iCurrency, bigDecimal2));
    }

    @Override
    public String format(ICustomFieldPossibleValue<?> iCustomFieldPossibleValue) {
        if (iCustomFieldPossibleValue == null) {
            return "";
        }
        Object obj = iCustomFieldPossibleValue.getCategory();
        if (obj == null) {
            return iCustomFieldPossibleValue.getValue();
        }
        return this.format(obj) + " - " + iCustomFieldPossibleValue.getValue();
    }

    @Override
    public String format(ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue) {
        CustomFieldType customFieldType;
        ICustomField iCustomField = iCustomFieldValue == null ? null : iCustomFieldValue.getField();
        CustomFieldType customFieldType2 = customFieldType = iCustomField == null ? null : iCustomField.getType();
        if (iCustomFieldValue == null || customFieldType == null) {
            return "";
        }
        Collection<Object> collection = null;
        switch (customFieldType) {
            case BOOLEAN: {
                return this.format(iCustomFieldValue.getBooleanValue());
            }
            case DATE: {
                return this.formatAsDate(iCustomFieldValue.getDateValue());
            }
            case DECIMAL: {
                int n = (Integer)ObjectHelper.defaultValue((Object)iCustomField.getDecimalDigits(), (Object)2);
                return this.format(iCustomFieldValue.getDecimalValue(), n);
            }
            case SINGLE_SELECTION: {
                return this.format((ICustomFieldPossibleValue<?>)iCustomFieldValue.getEnumeratedValue());
            }
            case MULTI_SELECTION: {
                if (iCustomFieldValue instanceof ICustomFieldValueWithList) {
                    collection = ((ICustomFieldValueWithList)iCustomFieldValue).getEnumeratedValues();
                } else if (iCustomFieldValue instanceof ICustomFieldValueWithSet) {
                    collection = ((ICustomFieldValueWithSet)iCustomFieldValue).getEnumeratedValues();
                }
                return this.format(collection);
            }
            case INTEGER: {
                return this.format(iCustomFieldValue.getIntegerValue());
            }
            case TEXT: {
                String string = iCustomFieldValue.getTextValue();
                return string != null ? string : "";
            }
            case RICH_TEXT: {
                String string = iCustomFieldValue.getRichTextValue();
                return string != null ? StringHelper.removeMarkupTags((String)string) : "";
            }
            case LINKED_ENTITY: {
                LinkedEntityVO linkedEntityVO = iCustomFieldValue.getLinkedEntityValue();
                if (linkedEntityVO != null) {
                    return this.format((INamedEntity)linkedEntityVO);
                }
                return "";
            }
            case STRING: {
                return (String)ObjectHelper.defaultValue((Object)iCustomFieldValue.getStringValue(), (Object)"");
            }
            case URL: {
                return ((String)ObjectHelper.defaultValue((Object)iCustomFieldValue.getStringValue(), (Object)"")).replace("http://", "").replace("https://", "");
            }
            case DYNAMIC_SELECTION: {
                return (String)ObjectHelper.coalesce((Object[])new String[]{iCustomFieldValue.getTextValue(), iCustomFieldValue.getStringValue(), ""});
            }
            case DYNAMIC_MULTI_SELECTION: {
                if (iCustomFieldValue instanceof ICustomFieldValueWithList) {
                    collection = ((ICustomFieldValueWithList)iCustomFieldValue).getDynamicValues();
                } else if (iCustomFieldValue instanceof ICustomFieldValueWithSet) {
                    collection = ((ICustomFieldValueWithSet)iCustomFieldValue).getDynamicValues();
                }
                return this.format(collection);
            }
            case FILE: {
                return this.format(iCustomFieldValue.getFileValues());
            }
            case IMAGE: {
                return this.format(iCustomFieldValue.getImageValues());
            }
        }
        throw new IllegalStateException("Unhandled custom field type: " + String.valueOf(customFieldType));
    }

    @Override
    public String format(IDatePeriod iDatePeriod) {
        String string;
        if (iDatePeriod == null) {
            return "";
        }
        String string2 = this.format(iDatePeriod.getBegin());
        if (string2.equals(string = this.format(iDatePeriod.getEnd()))) {
            return string2;
        }
        return this.formatPeriod(string2, string);
    }

    @Override
    public String format(IDecimalRange iDecimalRange, int n) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = iDecimalRange == null ? null : (BigDecimal)iDecimalRange.getMin();
        BigDecimal bigDecimal3 = bigDecimal = iDecimalRange == null ? null : (BigDecimal)iDecimalRange.getMax();
        if (bigDecimal2 == null && bigDecimal == null) {
            return "";
        }
        return this.formatRange(this.format(bigDecimal2, n), this.format(bigDecimal, n));
    }

    @Override
    public String format(IDimensions iDimensions) {
        if (iDimensions == null) {
            return "";
        }
        return iDimensions.getWidth() + "x" + iDimensions.getHeight();
    }

    @Override
    public String format(IDynamicFieldValue iDynamicFieldValue) {
        return iDynamicFieldValue == null ? "" : iDynamicFieldValue.asString();
    }

    @Override
    public String format(IFileSize iFileSize) {
        FileSizeUnit fileSizeUnit;
        Integer n = iFileSize == null ? null : iFileSize.getSize();
        FileSizeUnit fileSizeUnit2 = fileSizeUnit = iFileSize == null ? null : iFileSize.getUnit();
        if (n == null || fileSizeUnit == null) {
            return "";
        }
        return this.format(n) + this.message(fileSizeUnit.getMessageKey(), new Object[0]);
    }

    @Override
    public String format(IImage iImage) {
        if (iImage == null) {
            return "";
        }
        return iImage.getName() + " (" + iImage.getWidth() + "x" + iImage.getHeight() + ")";
    }

    @Override
    public String format(ILatLong iLatLong) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = iLatLong == null ? null : iLatLong.getLatitude();
        BigDecimal bigDecimal3 = bigDecimal = iLatLong == null ? null : iLatLong.getLongitude();
        if (bigDecimal2 == null || bigDecimal == null) {
            return "";
        }
        return this.format(bigDecimal2, 6) + ", " + this.format(bigDecimal, 6);
    }

    @Override
    public String format(INamedEntity iNamedEntity) {
        return iNamedEntity == null ? "" : iNamedEntity.getName();
    }

    @Override
    public String format(Integer n) {
        if (n == null) {
            return "";
        }
        return this.format(new BigDecimal(n), 0);
    }

    @Override
    public String format(ITimeInterval iTimeInterval) {
        TimeField timeField;
        Integer n = iTimeInterval == null ? null : iTimeInterval.getAmount();
        TimeField timeField2 = timeField = iTimeInterval == null ? null : iTimeInterval.getField();
        if (n == null || timeField == null) {
            return "";
        }
        MessageKey messageKey = TimeField.resolverForAmount(n).resolveKey(timeField);
        return this.format(n) + " " + this.message(messageKey, new Object[0]).toLowerCase();
    }

    @Override
    public String format(Long l) {
        return l == null ? "" : l.toString();
    }

    @Override
    public String format(Number number, FileSizeUnit fileSizeUnit) {
        if (number == null || fileSizeUnit == null) {
            return "";
        }
        return this.format(number) + " " + this.message(fileSizeUnit.getMessageKey(), new Object[0]);
    }

    @Override
    public String format(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            return this.format((Integer)object);
        }
        if (object instanceof Long) {
            return this.format((Long)object);
        }
        if (object instanceof BigDecimal) {
            return this.format((BigDecimal)object, 2);
        }
        if (object instanceof IDate) {
            return this.format((IDate)object);
        }
        if (object instanceof Boolean) {
            return this.format((Boolean)object);
        }
        if (object instanceof IDatePeriod) {
            return this.format((IDatePeriod)object);
        }
        if (object instanceof ICurrencyAmount) {
            return this.format((ICurrencyAmount)object);
        }
        if (object instanceof Range) {
            return this.format((Range)object);
        }
        if (object instanceof ICurrencyAmountRange) {
            return this.format((ICurrencyAmountRange)object);
        }
        if (object instanceof FormattableTimeBasedRate) {
            return this.format((FormattableTimeBasedRate)object);
        }
        if (object instanceof ICustomFieldValue) {
            return this.format((ICustomFieldValue)object);
        }
        if (object instanceof ICustomFieldPossibleValue) {
            return this.format((ICustomFieldPossibleValue)object);
        }
        if (object instanceof IDynamicFieldValue) {
            return this.format((IDynamicFieldValue)object);
        }
        if (object instanceof ITimeInterval) {
            return this.format((ITimeInterval)object);
        }
        if (object instanceof IFileSize) {
            return this.format((IFileSize)object);
        }
        if (object instanceof IDimensions) {
            return this.format((IDimensions)object);
        }
        if (object instanceof Collection) {
            return this.format((Collection)object);
        }
        if (object instanceof HasDisplay) {
            return this.format((HasDisplay)object);
        }
        if (object instanceof INamedEntity) {
            return this.format((INamedEntity)object);
        }
        if (object instanceof HasMessageKey) {
            return this.format((HasMessageKey)object);
        }
        if (object instanceof AccountOwner) {
            return this.format((AccountOwner)object);
        }
        if (object instanceof TranslationMessageSpecification) {
            return this.format((TranslationMessageSpecification)object);
        }
        if (object instanceof MessageKey) {
            return this.message((MessageKey)object, new Object[0]);
        }
        if (object instanceof Percentage) {
            return this.formatPercentage(((Percentage)object).getAmount());
        }
        if (object instanceof ProfileField) {
            return this.format((ProfileField)object);
        }
        if (object instanceof ILatLong) {
            return this.format((ILatLong)object);
        }
        if (object instanceof IImage) {
            return this.format((IImage)object);
        }
        if (object instanceof IBinaryFile) {
            return this.format((IBinaryFile)object);
        }
        if (object instanceof Supplier) {
            return this.format(((Supplier)object).get());
        }
        return object.toString();
    }

    @Override
    public String format(ProfileField profileField) {
        if (profileField instanceof BasicProfileField) {
            return this.message(((BasicProfileField)profileField).getMessageKey(), new Object[0]);
        }
        return this.format((Object)profileField);
    }

    @Override
    public String format(Range<?> range) {
        Object var2_2 = range == null ? null : range.getMin();
        Object var3_3 = range == null ? null : range.getMax();
        return this.formatRange(this.format((Object)var2_2), this.format((Object)var3_3));
    }

    @Override
    public String format(TranslationMessageSpecification translationMessageSpecification) {
        if (translationMessageSpecification == null || translationMessageSpecification.getKey() == null) {
            return "";
        }
        return this.message(translationMessageSpecification.getFormat(), translationMessageSpecification.getKey(), translationMessageSpecification.getArguments());
    }

    @Override
    public String formatAsDate(IDatePeriod iDatePeriod) {
        String string;
        if (iDatePeriod == null) {
            return "";
        }
        String string2 = this.formatAsDate(iDatePeriod.getBegin());
        if (string2.equals(string = this.formatAsDate(iDatePeriod.getEnd()))) {
            return string2;
        }
        return this.formatPeriod(string2, string);
    }

    @Override
    public String formatDuration(Long l) {
        if (l == null) {
            return "";
        }
        if (l < 1000L) {
            return this.message(GeneralKeys.Ui.DURATION_MILLIS, l);
        }
        long l2 = l / 1000L;
        if (l2 < 60L) {
            return this.message(GeneralKeys.Ui.DURATION_SECONDS, l2);
        }
        long l3 = l2 / 60L;
        l2 %= 60L;
        if (l3 < 60L) {
            return this.message(GeneralKeys.Ui.DURATION_MINUTES, l3, l2);
        }
        long l4 = l3 / 60L;
        l3 %= 60L;
        if (l4 < 24L) {
            return this.message(GeneralKeys.Ui.DURATION_HOURS, l4, l3, l2);
        }
        long l5 = l4 / 24L;
        return this.message(GeneralKeys.Ui.DURATION_DAYS, l5, l4 %= 24L, l3, l2);
    }

    @Override
    public String formatPercentage(BigDecimal bigDecimal) {
        return this.formatPercentage(bigDecimal, -1);
    }

    @Override
    public String formatPercentage(BigDecimal bigDecimal, int n) {
        if (bigDecimal == null) {
            return "";
        }
        return this.format(bigDecimal.multiply(BigDecimalHelper.ONE_HUNDRED), n) + "%";
    }

    @Override
    public String formatPercentage(Double d) {
        return this.formatPercentage(d, -1);
    }

    @Override
    public String formatPercentage(Double d, int n) {
        if (d == null) {
            return "";
        }
        return this.format(new BigDecimal("" + d * 100.0), n) + "%";
    }

    @Override
    public String formatPercentage(Integer n, Integer n2) {
        return this.formatPercentage(n, n2, 0);
    }

    @Override
    public String formatPercentage(Integer n, Integer n2, int n3) {
        if (n == null || n2 == null) {
            return "";
        }
        double d = n2 == 0 ? 0.0 : n.doubleValue() / n2.doubleValue();
        return this.formatPercentage(d, n3);
    }

    @Override
    public String formatRelated(AccountVO accountVO) {
        if (accountVO.getOwner() instanceof UserVO) {
            return this.format((AccountOwner)accountVO.getOwner());
        }
        return this.format((INamedEntity)accountVO.getType());
    }

    protected String fixSignIfZero(String string) {
        if (string != null && string.startsWith("-")) {
            boolean bl = true;
            for (char c : string.toCharArray()) {
                try {
                    if (Integer.parseInt(String.valueOf(c)) == 0) continue;
                    bl = false;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bl) {
                string = string.substring(1);
            }
        }
        return string;
    }

    protected String formatPeriod(String string, String string2) {
        if (StringHelper.isBlank((Object)string) && StringHelper.isBlank((Object)string2)) {
            return "";
        }
        if (StringHelper.isNotBlank((Object)string) && StringHelper.isNotBlank((Object)string2)) {
            if (string.equals(string2)) {
                return string;
            }
            return this.message(GeneralKeys.Ui.PERIOD_FULL, string, string2);
        }
        if (StringHelper.isNotBlank((Object)string)) {
            return this.message(GeneralKeys.Ui.PERIOD_BEGINNING_AT, string);
        }
        return this.message(GeneralKeys.Ui.PERIOD_ENDING_AT, string2);
    }

    protected String formatRange(String string, String string2) {
        if (StringHelper.isBlank((Object)string) && StringHelper.isBlank((Object)string2)) {
            return "";
        }
        if (StringHelper.isNotBlank((Object)string) && StringHelper.isNotBlank((Object)string2)) {
            if (string.equals(string2)) {
                return string;
            }
            return this.message(GeneralKeys.Ui.RANGE_FULL, string, string2);
        }
        if (StringHelper.isNotBlank((Object)string)) {
            return this.message(GeneralKeys.Ui.RANGE_GREATER_THAN, string);
        }
        return this.message(GeneralKeys.Ui.RANGE_LESS_THAN, string2);
    }

    protected abstract String message(MessageFormat var1, MessageKey var2, Object ... var3);

    protected final String message(MessageKey messageKey, Object ... objectArray) {
        return this.message(null, messageKey, objectArray);
    }

    protected BigDecimal roundHour(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        BigDecimal bigDecimal4 = new BigDecimal("30");
        if (bigDecimal3.compareTo(bigDecimal4) > 0) {
            bigDecimal2 = bigDecimal2.add(BigDecimal.ONE);
        }
        if (bigDecimal2.compareTo(bigDecimal4) > 0) {
            bigDecimal = bigDecimal.add(BigDecimal.ONE);
        }
        return bigDecimal;
    }

    protected Pair<BigDecimal, BigDecimal> splitDecimal(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal.remainder(BigDecimal.ONE);
        BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2).setScale(0);
        return new Pair((Object)bigDecimal3, (Object)bigDecimal2);
    }
}

