/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.users.addresses;

import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;

public enum AddressQueryField implements HasMessageKey
{
    ADDRESS,
    NEIGHBORHOOD,
    PO_BOX,
    ZIP,
    CITY,
    REGION,
    COUNTRY;

    private final String internalName = StringHelper.camelize((String)this.name());

    public static AddressQueryField getByInternalName(String string) {
        for (AddressQueryField addressQueryField : AddressQueryField.values()) {
            if (!addressQueryField.internalName.equals(string)) continue;
            return addressQueryField;
        }
        return null;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return UsersKeys.Users.ADDRESS;
            }
            case 4: {
                return AddressFields.CITY.getMessageKey();
            }
            case 6: {
                return AddressFields.COUNTRY.getMessageKey();
            }
            case 1: {
                return AddressFields.NEIGHBORHOOD.getMessageKey();
            }
            case 2: {
                return AddressFields.PO_BOX.getMessageKey();
            }
            case 5: {
                return AddressFields.REGION.getMessageKey();
            }
            case 3: {
                return AddressFields.ZIP.getMessageKey();
            }
        }
        return null;
    }

    public String internalName() {
        return this.internalName;
    }
}

