/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.licensing;

import org.cyclos.model.general.GeneralKeys;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum LicenseStatus implements HasMessageKey
{
    OK,
    EXPIRED,
    ABOUT_TO_EXPIRE,
    MAX_USERS_REACHED,
    MAX_USERS_ABOUT_TO_BE_REACHED;


    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return null;
            }
            case 1: {
                return GeneralKeys.Ui.LICENSE_MESSAGE_EXPIRED;
            }
            case 2: {
                return GeneralKeys.Ui.LICENSE_MESSAGE_ABOUT_TO_EXPIRE;
            }
            case 3: {
                return GeneralKeys.Ui.LICENSE_MESSAGE_MAX_USERS_REACHED;
            }
            case 4: {
                return GeneralKeys.Ui.LICENSE_MESSAGE_MAX_USERS_ABOUT_TO_BE_REACHED;
            }
        }
        return null;
    }

    public boolean isError() {
        return this == EXPIRED || this == MAX_USERS_REACHED;
    }

    public boolean isOk() {
        return this == OK;
    }

    public boolean isWarning() {
        return this == ABOUT_TO_EXPIRE || this == MAX_USERS_ABOUT_TO_BE_REACHED;
    }
}

