/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.imports;

import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.utils.MessageKey;

public enum TransactionImportField implements ImportField
{
    FROM("from"),
    TO("to"),
    FROM_NAME("fromName"),
    TO_NAME("toName"),
    TYPE("type"),
    DATE("date"),
    AMOUNT("amount"),
    DESCRIPTION("description");

    public static final String PREFIX = "TRANSACTION";
    private String name = null;

    private TransactionImportField(String string2) {
        this.name = string2;
    }

    @Override
    public ImportType getImportType() {
        return ImportType.TRANSFERS_IMPORT;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 5: {
                return BankingKeys.Transactions.DATE;
            }
            case 0: {
                return BankingKeys.Accounts.FROM;
            }
            case 1: {
                return BankingKeys.Transactions.RECEIVER;
            }
            case 4: {
                return BankingKeys.Transactions.TYPE;
            }
            case 6: {
                return BankingKeys.Transactions.AMOUNT;
            }
            case 7: {
                return GeneralKeys.Ui.DESCRIPTION;
            }
            case 2: {
                return BankingKeys.Transactions.FROM_NAME;
            }
            case 3: {
                return BankingKeys.Transactions.TO_NAME;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String prefix() {
        return PREFIX;
    }
}

