/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.exportformats;

import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum ExportFormatContext implements HasMessageKey
{
    ACCOUNT_HISTORY(true, true),
    TRANSFERS_OVERVIEW(false, true),
    TRANS_DETAILS(true, false),
    ARCHIVED_ACCOUNT_HISTORY(true, false),
    ARCHIVED_TRANSFER(true, false),
    TRANSACTIONS_SEARCH(true, true),
    TRANSACTIONS_OVERVIEW(false, true),
    INSTALLMENTS_SEARCH(true, true),
    INSTALLMENTS_OVERVIEW(false, true),
    USERS_SEARCH(true, true),
    USERS_WITH_BALANCES(false, true),
    BALANCE_LIMITS_OVERVIEW(false, true),
    PAYMENT_AMOUNT_LIMITS_OVERVIEW(false, true),
    ADVERTISEMENT_DETAILS(true, false),
    ORDER_DETAILS(true, false),
    RECORDS_SEARCH(false, true),
    RECORDS_OVERVIEW(false, true),
    SHARED_FIELDS_RECORDS_SEARCH(false, true),
    TOKENS_SEARCH(false, true),
    VOUCHERS_SEARCH(true, true),
    USER_VOUCHERS_SEARCH(true, false),
    VOUCHER_DETAILS(true, false),
    VOUCHER_TRANSACTION_DETAILS(true, false),
    CUSTOM_OPERATION(true, true),
    ENTITY_LOGS(false, true);

    private final boolean pdf;
    private final boolean tabular;

    private ExportFormatContext(boolean bl, boolean bl2) {
        this.pdf = bl;
        this.tabular = bl2;
    }

    public String fileName(String string) {
        return this.name().toLowerCase().replace('_', '-') + "." + string.replace(".", "");
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 11: {
                return SystemKeys.ExportFormats.CONTEXT_BALANCE_LIMITS_OVERVIEW;
            }
            case 12: {
                return SystemKeys.ExportFormats.CONTEXT_PAYMENT_AMOUNT_LIMITS_OVERVIEW;
            }
            case 23: {
                return SystemKeys.ExportFormats.CONTEXT_CUSTOM_OPERATION;
            }
            case 8: {
                return SystemKeys.ExportFormats.CONTEXT_INSTALLMENTS_OVERVIEW;
            }
            case 7: {
                return SystemKeys.ExportFormats.CONTEXT_INSTALLMENTS_SEARCH;
            }
            case 15: {
                return SystemKeys.ExportFormats.CONTEXT_RECORDS_SEARCH;
            }
            case 16: {
                return SystemKeys.ExportFormats.CONTEXT_RECORDS_OVERVIEW;
            }
            case 17: {
                return SystemKeys.ExportFormats.CONTEXT_SHARED_FIELDS_RECORDS_SEARCH;
            }
            case 6: {
                return SystemKeys.ExportFormats.CONTEXT_TRANSACTIONS_OVERVIEW;
            }
            case 5: {
                return SystemKeys.ExportFormats.CONTEXT_TRANSACTIONS_SEARCH;
            }
            case 0: {
                return SystemKeys.ExportFormats.CONTEXT_ACCOUNT_HISTORY;
            }
            case 3: {
                return SystemKeys.ExportFormats.CONTEXT_ARCHIVED_ACCOUNT_HISTORY;
            }
            case 4: {
                return SystemKeys.ExportFormats.CONTEXT_ARCHIVED_TRANSFER;
            }
            case 1: {
                return SystemKeys.ExportFormats.CONTEXT_TRANSFERS_OVERVIEW;
            }
            case 2: {
                return SystemKeys.ExportFormats.CONTEXT_TRANS_DETAILS;
            }
            case 9: {
                return SystemKeys.ExportFormats.CONTEXT_USERS_SEARCH;
            }
            case 10: {
                return SystemKeys.ExportFormats.CONTEXT_USERS_WITH_BALANCES;
            }
            case 18: {
                return SystemKeys.ExportFormats.CONTEXT_TOKENS_SEARCH;
            }
            case 19: {
                return SystemKeys.ExportFormats.CONTEXT_VOUCHERS_SEARCH;
            }
            case 20: {
                return SystemKeys.ExportFormats.CONTEXT_USER_VOUCHERS_SEARCH;
            }
            case 21: {
                return SystemKeys.ExportFormats.CONTEXT_VOUCHER_DETAILS;
            }
            case 22: {
                return SystemKeys.ExportFormats.CONTEXT_VOUCHER_TRANSACTION_DETAILS;
            }
            case 13: {
                return SystemKeys.ExportFormats.CONTEXT_ADVERTISEMENT_DETAILS;
            }
            case 14: {
                return SystemKeys.ExportFormats.CONTEXT_ORDER_DETAILS;
            }
            case 24: {
                return SystemKeys.ExportFormats.CONTEXT_ENTITY_LOGS;
            }
        }
        return null;
    }

    public boolean isPdf() {
        return this.pdf;
    }

    public boolean isTabular() {
        return this.tabular;
    }
}

