/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.messaging.notifications;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.cyclos.model.messaging.notifications.AccountNotificationType;
import org.cyclos.model.messaging.notifications.AdminNotificationType;
import org.cyclos.model.messaging.notifications.BrokeringNotificationType;
import org.cyclos.model.messaging.notifications.FeedbackAndReferenceNotificationType;
import org.cyclos.model.messaging.notifications.MarketplaceBuyerNotificationType;
import org.cyclos.model.messaging.notifications.MarketplaceSellerNotificationType;
import org.cyclos.model.messaging.notifications.NotificationEntityType;
import org.cyclos.model.messaging.notifications.NotificationRootType;
import org.cyclos.model.messaging.notifications.PersonalNotificationType;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.PrefixedEnum;

public interface INotificationType
extends PrefixedEnum,
HasMessageKey {
    public static final Comparator<INotificationType> COMPARATOR = (iNotificationType, iNotificationType2) -> {
        if (iNotificationType instanceof AdminNotificationType && iNotificationType2 instanceof AdminNotificationType) {
            return ((AdminNotificationType)iNotificationType).compareTo((AdminNotificationType)iNotificationType2);
        }
        if (iNotificationType instanceof AdminNotificationType) {
            return -1;
        }
        if (iNotificationType2 instanceof AdminNotificationType) {
            return 1;
        }
        if (iNotificationType instanceof UserNotificationType && iNotificationType2 instanceof UserNotificationType) {
            return UserNotificationType.COMPARATOR.compare((UserNotificationType)iNotificationType, (UserNotificationType)iNotificationType2);
        }
        throw new IllegalStateException("Unknown instances in comparator: " + String.valueOf(iNotificationType) + " and " + String.valueOf(iNotificationType2));
    };

    public MessageKey getKeyForSms();

    public MessageKey getKeyForText();

    public NotificationEntityType getNotificationEntityType();

    public static class Mapping {
        private static final Map<String, Class<? extends PrefixedEnum>> MAPPING;

        public static Map<String, Class<? extends PrefixedEnum>> get() {
            return MAPPING;
        }

        static {
            HashMap<String, Class<BrokeringNotificationType>> hashMap = new HashMap<String, Class<BrokeringNotificationType>>();
            hashMap.put("ADMIN", AdminNotificationType.class);
            hashMap.put(PersonalNotificationType.PREFIX, PersonalNotificationType.class);
            hashMap.put(AccountNotificationType.PREFIX, AccountNotificationType.class);
            hashMap.put(FeedbackAndReferenceNotificationType.PREFIX, FeedbackAndReferenceNotificationType.class);
            hashMap.put(MarketplaceBuyerNotificationType.PREFIX, MarketplaceBuyerNotificationType.class);
            hashMap.put(MarketplaceSellerNotificationType.PREFIX, MarketplaceSellerNotificationType.class);
            hashMap.put(BrokeringNotificationType.PREFIX, BrokeringNotificationType.class);
            for (NotificationRootType notificationRootType : NotificationRootType.values()) {
                if (hashMap.get(notificationRootType.name()) != null) continue;
                throw new IllegalStateException("No mapping for " + notificationRootType.name());
            }
            MAPPING = Collections.unmodifiableMap(hashMap);
        }
    }
}

