/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.messaging.notifications;

import org.cyclos.model.access.Role;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.notifications.NotificationEntityType;
import org.cyclos.model.messaging.notifications.NotificationRootType;
import org.cyclos.model.messaging.notifications.OperatorNotificationPropagation;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.MessageKey;

public enum BrokeringNotificationType implements UserNotificationType
{
    MEMBER_UNASSIGNED,
    MEMBER_ASSIGNED,
    AD_PENDING_AUTHORIZATION;

    private static EnumMessageKeyResolver<BrokeringNotificationType> resolverForSms;
    private static EnumMessageKeyResolver<BrokeringNotificationType> resolverForText;
    public static final String PREFIX;

    public static EnumMessageKeyResolver<BrokeringNotificationType> resolverForSms() {
        if (resolverForSms == null) {
            resolverForSms = brokeringNotificationType -> {
                switch (brokeringNotificationType.ordinal()) {
                    case 0: {
                        return MessagingKeys.Notifications.USER_MEMBER_UNASSIGNED_SMS;
                    }
                    case 1: {
                        return MessagingKeys.Notifications.USER_MEMBER_ASSIGNED_SMS;
                    }
                    case 2: {
                        return MessagingKeys.Notifications.USER_AD_PENDING_AUTHORIZATION_SMS;
                    }
                }
                return null;
            };
        }
        return resolverForSms;
    }

    public static EnumMessageKeyResolver<BrokeringNotificationType> resolverForText() {
        if (resolverForText == null) {
            resolverForText = brokeringNotificationType -> {
                switch (brokeringNotificationType.ordinal()) {
                    case 0: {
                        return MessagingKeys.Notifications.USER_MEMBER_UNASSIGNED_TEXT;
                    }
                    case 1: {
                        return MessagingKeys.Notifications.USER_MEMBER_ASSIGNED_TEXT;
                    }
                    case 2: {
                        return MessagingKeys.Notifications.USER_AD_PENDING_AUTHORIZATION_TEXT;
                    }
                }
                return null;
            };
        }
        return resolverForText;
    }

    @Override
    public MessageKey getKeyForSms() {
        return BrokeringNotificationType.resolverForSms().resolveKey(this);
    }

    @Override
    public MessageKey getKeyForText() {
        return BrokeringNotificationType.resolverForText().resolveKey(this);
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return MessagingKeys.Notifications.USER_MEMBER_UNASSIGNED;
            }
            case 1: {
                return MessagingKeys.Notifications.USER_MEMBER_ASSIGNED;
            }
            case 2: {
                return MessagingKeys.Notifications.USER_AD_PENDING_AUTHORIZATION;
            }
        }
        return null;
    }

    @Override
    public NotificationEntityType getNotificationEntityType() {
        switch (this.ordinal()) {
            case 2: {
                return NotificationEntityType.MARKETPLACE;
            }
            case 1: {
                return NotificationEntityType.USER;
            }
            case 0: {
                return NotificationEntityType.USER;
            }
        }
        return null;
    }

    @Override
    public OperatorNotificationPropagation getPropagation() {
        return OperatorNotificationPropagation.ALL_OPERATORS;
    }

    @Override
    public Role getRole() {
        return Role.BROKER;
    }

    @Override
    public NotificationRootType getRootType() {
        return NotificationRootType.BROKERING;
    }

    public String prefix() {
        return PREFIX;
    }

    static {
        PREFIX = NotificationRootType.BROKERING.name();
    }
}

