/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.contentmanagement.themes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.themes.MobileThemeImage;
import org.cyclos.model.contentmanagement.themes.ThemeBackground;
import org.cyclos.model.contentmanagement.themes.ThemeImageEnum;
import org.cyclos.model.contentmanagement.themes.ThemeMapMarker;
import org.cyclos.model.contentmanagement.themes.ThemeType;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum ThemeImageType implements HasMessageKey
{
    CUSTOM(null, ThemeType.values()),
    BACKGROUND(ThemeBackground.class, ThemeType.MAIN_WEB),
    MAP_MARKER(ThemeMapMarker.class, ThemeType.MAIN_WEB),
    MOBILE(MobileThemeImage.class, ThemeType.MOBILE);

    private final List<ThemeImageEnum> items;
    private Set<ThemeType> themeTypes;

    public static ThemeImageType getByEnumItem(ThemeImageEnum themeImageEnum) throws IllegalArgumentException {
        if (themeImageEnum instanceof ThemeBackground) {
            return BACKGROUND;
        }
        if (themeImageEnum instanceof ThemeMapMarker) {
            return MAP_MARKER;
        }
        if (themeImageEnum instanceof MobileThemeImage) {
            return MOBILE;
        }
        throw new IllegalArgumentException("Unknown enum item: " + String.valueOf(themeImageEnum));
    }

    private ThemeImageType(Class<? extends Enum<?>> clazz, ThemeType ... themeTypeArray) {
        if (clazz == null) {
            this.items = null;
        } else {
            this.items = new ArrayList<ThemeImageEnum>();
            Stream.of(clazz.getEnumConstants()).map(enum_ -> (ThemeImageEnum)((Object)enum_)).forEach(this.items::add);
        }
        this.themeTypes = CollectionHelper.asSet((Object[])themeTypeArray);
    }

    public ThemeImageEnum getEnumItem(String string) throws IllegalArgumentException {
        if (this.items == null) {
            throw new IllegalArgumentException("No corresponding enumeration for this nature");
        }
        return this.items.stream().filter(themeImageEnum -> themeImageEnum.name().equals(string)).findAny().orElseGet(() -> {
            throw new IllegalArgumentException("Invalid image name " + string + " for type " + this.name());
        });
    }

    public List<ThemeImageEnum> getEnumItems() {
        return this.items == null ? Collections.emptyList() : this.items;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return ContentManagementKeys.Themes.IMAGE_TYPE_CUSTOM;
            }
            case 1: {
                return ContentManagementKeys.Themes.IMAGE_TYPE_BACKGROUND;
            }
            case 2: {
                return ContentManagementKeys.Themes.IMAGE_TYPE_MAP_MARKER;
            }
            case 3: {
                return ContentManagementKeys.Themes.IMAGE_TYPE_MOBILE;
            }
        }
        return null;
    }

    public boolean isSupported(ThemeType themeType) {
        return this.themeTypes.contains(themeType);
    }
}

