/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.banking.vouchers;

import java.util.EnumSet;
import java.util.Set;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum VoucherStatus implements HasMessageKey
{
    OPEN,
    BLOCKED,
    INACTIVE,
    EXPIRED,
    ACTIVATION_EXPIRED,
    CANCELED,
    PENDING,
    REDEEMED;

    private static final Set<VoucherStatus> ACTIVATABLE;
    private static final Set<VoucherStatus> ACTUALLY_OPEN;
    private static final Set<VoucherStatus> EXPIRABLE;
    private static final Set<VoucherStatus> FINAL;

    @GwtIncompatible
    public static VoucherStatus[] getActivatableStatuses() {
        return (VoucherStatus[])ACTIVATABLE.toArray(VoucherStatus[]::new);
    }

    @GwtIncompatible
    public static VoucherStatus[] getActuallyOpenStatuses() {
        return (VoucherStatus[])ACTUALLY_OPEN.toArray(VoucherStatus[]::new);
    }

    @GwtIncompatible
    public static VoucherStatus[] getExpirableStatuses() {
        return (VoucherStatus[])EXPIRABLE.toArray(VoucherStatus[]::new);
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return BankingKeys.Vouchers.STATUS_OPEN;
            }
            case 1: {
                return BankingKeys.Vouchers.STATUS_BLOCKED;
            }
            case 3: {
                return BankingKeys.Vouchers.STATUS_EXPIRED;
            }
            case 4: {
                return BankingKeys.Vouchers.STATUS_ACTIVATION_EXPIRED;
            }
            case 5: {
                return BankingKeys.Vouchers.STATUS_CANCELED;
            }
            case 6: {
                return BankingKeys.Vouchers.STATUS_PENDING;
            }
            case 7: {
                return BankingKeys.Vouchers.STATUS_REDEEMED;
            }
            case 2: {
                return BankingKeys.Vouchers.STATUS_INACTIVE;
            }
        }
        return null;
    }

    public boolean isActuallyOpen() {
        return ACTUALLY_OPEN.contains(this);
    }

    public boolean isExpirable() {
        return EXPIRABLE.contains(this);
    }

    public boolean isFinal() {
        return FINAL.contains(this);
    }

    public boolean isShowQrCode() {
        return this == OPEN || this == BLOCKED || this == INACTIVE;
    }

    static {
        ACTIVATABLE = EnumSet.of(BLOCKED, INACTIVE);
        ACTUALLY_OPEN = EnumSet.of(OPEN, PENDING);
        EXPIRABLE = EnumSet.of(OPEN, PENDING, BLOCKED, INACTIVE);
        FINAL = EnumSet.of(CANCELED, REDEEMED, EXPIRED);
    }
}

