/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.access.channels;

import org.cyclos.model.general.GeneralKeys;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum BuiltInChannel implements HasMessageKey
{
    MAIN("main", "Main", false),
    WEB_SERVICES("webServices", "Web services", false),
    OIDC("oidc", "OAuth2 / OpenID Connect", true),
    SMS("sms", "SMS", true),
    POS("pos", "Pay at POS", true),
    MOBILE("mobile", "Mobile app", false),
    TICKET("ticket", "Ticket", false),
    EASY_INVOICE("easyInvoice", "Easy invoice", false);

    private final String internalName;
    private final String displayName;
    private final boolean specificEntryPoint;

    public static BuiltInChannel getByInternalName(String string) {
        for (BuiltInChannel builtInChannel : BuiltInChannel.values()) {
            if (!builtInChannel.internalName.equals(string)) continue;
            return builtInChannel;
        }
        return null;
    }

    private BuiltInChannel(String string2, String string3, boolean bl) {
        this.internalName = string2;
        this.displayName = string3;
        this.specificEntryPoint = bl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return GeneralKeys.InitialData.CHANNEL_MAIN;
            }
            case 1: {
                return GeneralKeys.InitialData.CHANNEL_WEB_SERVICES;
            }
            case 3: {
                return GeneralKeys.InitialData.CHANNEL_SMS;
            }
            case 4: {
                return GeneralKeys.InitialData.CHANNEL_POS;
            }
            case 5: {
                return GeneralKeys.InitialData.CHANNEL_MOBILE;
            }
            case 6: {
                return GeneralKeys.InitialData.CHANNEL_TICKET;
            }
            case 7: {
                return GeneralKeys.InitialData.CHANNEL_EASY_INVOICE;
            }
            case 2: {
                return GeneralKeys.InitialData.CHANNEL_OIDC;
            }
        }
        return null;
    }

    public boolean isSpecificEntryPoint() {
        return this.specificEntryPoint;
    }
}

