/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model;

import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum Availability implements HasMessageKey
{
    OPTIONAL,
    REQUIRED,
    DISABLED;

    private static EnumMessageKeyResolver<Availability> resolverForPasswordPolicy;

    public static Availability of(boolean bl, boolean bl2) {
        if (!bl) {
            return DISABLED;
        }
        return bl2 ? REQUIRED : OPTIONAL;
    }

    public static EnumMessageKeyResolver<Availability> resolverForPasswordPolicy() {
        if (resolverForPasswordPolicy == null) {
            resolverForPasswordPolicy = availability -> {
                switch (availability.ordinal()) {
                    case 2: {
                        return AccessKeys.PasswordTypes.PASSWORD_CHARACTER_POLICY_NOT_ALLOWED;
                    }
                    case 0: {
                        return AccessKeys.PasswordTypes.PASSWORD_CHARACTER_POLICY_ALLOWED;
                    }
                    case 1: {
                        return AccessKeys.PasswordTypes.PASSWORD_CHARACTER_POLICY_REQUIRED;
                    }
                }
                return null;
            };
        }
        return resolverForPasswordPolicy;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 2: {
                return GeneralKeys.Ui.AVAILABILITY_DISABLED;
            }
            case 0: {
                return GeneralKeys.Ui.AVAILABILITY_OPTIONAL;
            }
            case 1: {
                return GeneralKeys.Ui.AVAILABILITY_REQUIRED;
            }
        }
        return null;
    }
}

