/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support.master;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionResponse;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.ObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class AcknowledgedResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField ACKNOWLEDGED = new ParseField("acknowledged", new String[0]);
    protected boolean acknowledged;
    private static final ConstructingObjectParser<Boolean, Void> ACKNOWLEDGED_FLAG_PARSER = new ConstructingObjectParser("acknowledged_flag", true, args -> (Boolean)args[0]);

    protected static <T extends AcknowledgedResponse> void declareAcknowledgedField(ConstructingObjectParser<T, Void> objectParser) {
        objectParser.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.booleanValue(), ACKNOWLEDGED, ObjectParser.ValueType.BOOLEAN);
    }

    public AcknowledgedResponse(StreamInput in) throws IOException {
        super(in);
        this.acknowledged = in.readBoolean();
    }

    public AcknowledgedResponse(StreamInput in, boolean readAcknowledged) throws IOException {
        super(in);
        if (readAcknowledged) {
            this.acknowledged = in.readBoolean();
        }
    }

    public AcknowledgedResponse(boolean acknowledged) {
        this.acknowledged = acknowledged;
    }

    public final boolean isAcknowledged() {
        return this.acknowledged;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.acknowledged);
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACKNOWLEDGED.getPreferredName(), this.isAcknowledged());
        this.addCustomFields(builder, params);
        builder.endObject();
        return builder;
    }

    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static AcknowledgedResponse fromXContent(XContentParser parser) throws IOException {
        return new AcknowledgedResponse((Boolean)ACKNOWLEDGED_FLAG_PARSER.apply(parser, null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcknowledgedResponse that = (AcknowledgedResponse)o;
        return this.isAcknowledged() == that.isAcknowledged();
    }

    public int hashCode() {
        return Objects.hash(this.isAcknowledged());
    }

    static {
        ACKNOWLEDGED_FLAG_PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.booleanValue(), ACKNOWLEDGED, ObjectParser.ValueType.BOOLEAN);
    }
}

