/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.cyclos.entities.messaging.InboundSms;
import org.cyclos.entities.system.SmsChannelConfiguration;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomScriptAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.utils.sms.InboundSmsBasicData;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.InboundSmsRequestHandler;
import org.cyclos.impl.utils.sms.InboundSmsRequestHandlerImpl;
import org.cyclos.impl.utils.sms.InboundSmsResponseType;
import org.cyclos.model.system.scripts.InboundSmsScriptFunction;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.utils.RequestInfo;
import org.cyclos.model.utils.ResponseInfo;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class ScriptInboundSmsRequestHandlerImpl
implements InboundSmsRequestHandler {
    public static final String GENERATE_RESPONSE_FUNCTION_NAME = "generateResponse";
    public static final String GENERATE_RESPONSE_MISSING_PARAMETERS_FUNCTION_NAME = "generateResponseForMissingParameters";
    public static final String RESOLVE_SMS_DATA_FUNCTION_NAME = "resolveSmsData";
    public static final String ATTR_CONFIGURATION = "configuration";
    public static final String ATTR_CHANNEL_CONFIGURATION = "channelConfiguration";
    public static final String ATTR_REQUEST = "request";
    public static final String ATTR_INBOUND_SMS_RESPONSE_TYPE = "inboundSmsResponseType";
    public static final String ATTR_INBOUND_SMS_EXCEPTION = "inboundSmsException";
    public static final String ATTR_INBOUND_SMS_DATA = "inboundSmsData";
    public static final String ATTR_INBOUND_SMS = "inboundSms";
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private BeanHandler beanHandler;
    private InboundSmsRequestHandler fallback;

    public ResponseInfo generateResponse(ConfigurationAccessor configurationAccessor, SmsChannelConfiguration smsChannelConfiguration, RequestInfo requestInfo, InboundSmsData inboundSmsData, InboundSms inboundSms) {
        ResponseInfo responseInfo = this.doGenerateResponse(configurationAccessor, smsChannelConfiguration, requestInfo, InboundSmsResponseType.SUCCESS, inboundSmsData, inboundSms, null);
        if (responseInfo == null) {
            responseInfo = this.fallback.generateResponse(configurationAccessor, smsChannelConfiguration, requestInfo, inboundSmsData, inboundSms);
        }
        return responseInfo;
    }

    public ResponseInfo generateResponseForError(ConfigurationAccessor configurationAccessor, SmsChannelConfiguration smsChannelConfiguration, RequestInfo requestInfo, Exception exception) {
        ResponseInfo responseInfo = this.doGenerateResponse(configurationAccessor, smsChannelConfiguration, requestInfo, InboundSmsResponseType.UNKNOWN_ERROR, null, null, exception);
        if (responseInfo == null) {
            responseInfo = this.fallback.generateResponseForError(configurationAccessor, smsChannelConfiguration, requestInfo, exception);
        }
        return responseInfo;
    }

    public ResponseInfo generateResponseForMissingParameters(ConfigurationAccessor configurationAccessor, SmsChannelConfiguration smsChannelConfiguration, RequestInfo requestInfo) {
        ResponseInfo responseInfo = this.doGenerateResponse(configurationAccessor, smsChannelConfiguration, requestInfo, InboundSmsResponseType.MISSING_PARAMETERS_ERROR, null, null, null);
        if (responseInfo == null) {
            responseInfo = this.fallback.generateResponseForMissingParameters(configurationAccessor, smsChannelConfiguration, requestInfo);
        }
        return responseInfo;
    }

    @PostConstruct
    public void initialize() {
        this.fallback = (InboundSmsRequestHandler)this.beanHandler.getBean(InboundSmsRequestHandlerImpl.class);
    }

    public InboundSmsBasicData resolveSmsData(ConfigurationAccessor configurationAccessor, SmsChannelConfiguration smsChannelConfiguration, RequestInfo requestInfo) {
        InboundSmsBasicData inboundSmsBasicData = (InboundSmsBasicData)this.prepareScript(configurationAccessor, smsChannelConfiguration).bind(ATTR_REQUEST, (Object)requestInfo).run(InboundSmsBasicData.class, (ScriptFunction)InboundSmsScriptFunction.RESOLVE_SMS_DATA);
        if (inboundSmsBasicData == null) {
            inboundSmsBasicData = this.fallback.resolveSmsData(configurationAccessor, smsChannelConfiguration, requestInfo);
        }
        if (StringHelper.isNotBlank((Object)inboundSmsBasicData.getMessage()) && CollectionHelper.isEmpty((Iterable)inboundSmsBasicData.getMessageParts())) {
            inboundSmsBasicData.setMessageParts(this.splitMessageParts(inboundSmsBasicData.getMessage()));
        }
        return inboundSmsBasicData;
    }

    private ResponseInfo doGenerateResponse(ConfigurationAccessor configurationAccessor, SmsChannelConfiguration smsChannelConfiguration, RequestInfo requestInfo, InboundSmsResponseType inboundSmsResponseType, InboundSmsData inboundSmsData, InboundSms inboundSms, Exception exception) {
        ResponseInfo responseInfo = (ResponseInfo)this.prepareScript(configurationAccessor, smsChannelConfiguration).bind(ATTR_REQUEST, (Object)requestInfo).bind(ATTR_INBOUND_SMS_RESPONSE_TYPE, (Object)inboundSmsResponseType).bind(ATTR_INBOUND_SMS_EXCEPTION, (Object)exception).bind(ATTR_INBOUND_SMS_DATA, (Object)inboundSmsData).bind(ATTR_INBOUND_SMS, (Object)inboundSms).run(ResponseInfo.class, (ScriptFunction)InboundSmsScriptFunction.GENERATE_RESPONSE);
        return responseInfo;
    }

    private CustomScriptAccessor prepareScript(ConfigurationAccessor configurationAccessor, SmsChannelConfiguration smsChannelConfiguration) {
        CustomScriptAccessor customScriptAccessor = this.customScriptService.newAccessor(smsChannelConfiguration.getScript(), smsChannelConfiguration.getScriptParameters()).bind(ATTR_CONFIGURATION, (Object)configurationAccessor).bind(ATTR_CHANNEL_CONFIGURATION, (Object)smsChannelConfiguration);
        return customScriptAccessor;
    }

    private List<String> splitMessageParts(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            for (String string2 : string.split("\\ ")) {
                if ((string2 = StringHelper.trimToNull((Object)string2)) == null) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }
}

