/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.impl.utils.sms.BaseSmsOperation;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.SmsOperationException;
import org.cyclos.impl.utils.sms.SmsParameterProcessor;
import org.cyclos.model.CyclosException;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.vouchers.RedeemVoucherDTO;
import org.cyclos.model.banking.vouchers.RedeemingNotAllowedForUserException;
import org.cyclos.model.banking.vouchers.RedeemingNotAllowedForVoucherException;
import org.cyclos.model.banking.vouchers.RedeemingNotAllowedTodayException;
import org.cyclos.model.banking.vouchers.RedeemingNotAllowedYetException;
import org.cyclos.model.banking.vouchers.VoucherTransactionResultVO;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.security.Security;
import org.cyclos.services.banking.VoucherService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.WeekDay;
import org.springframework.beans.factory.annotation.Autowired;

public class RedeemVoucherSmsOperation
extends BaseSmsOperation {
    private static final Logger LOG = LogManager.getLogger(RedeemVoucherSmsOperation.class);
    @Autowired
    @Security
    private VoucherService voucherService;

    @Override
    protected void checkParametersCount(SmsOperationConfiguration smsOperationConfiguration, List<String> list) throws SmsOperationException {
        if (CollectionHelper.size(list) < 1) {
            throw new SmsOperationException((Object)BaseSmsOperation.BaseError.INVALID_PARAMETERS_COUNT.getMessageKey(), new Object[0]);
        }
    }

    @Override
    protected void doExecute(SmsOperationConfiguration smsOperationConfiguration, MobilePhone mobilePhone, InboundSmsData inboundSmsData, SmsParameterProcessor smsParameterProcessor) throws CyclosException {
        VoucherTransactionResultVO voucherTransactionResultVO;
        LOG.debug(String.format("Executing SMS Redeem voucher operation (user: %1$s, sms: %2$s)", mobilePhone != null ? mobilePhone.getUser().getUsername() : "", inboundSmsData));
        RedeemVoucherDTO redeemVoucherDTO = new RedeemVoucherDTO();
        String string = smsParameterProcessor.remaining((Object)MessagingKeys.Notifications.SMS_REDEEM_VOUCHER_PARAMETER_TOKEN, "");
        redeemVoucherDTO.setToken(string);
        try {
            voucherTransactionResultVO = this.voucherService.redeem(redeemVoucherDTO);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            throw new SmsOperationException((Throwable)entityNotFoundException, (Object)RedeemVoucherError.INVALID_TOKEN.getMessageKey(), new Object[0]);
        }
        catch (RedeemingNotAllowedForVoucherException redeemingNotAllowedForVoucherException) {
            String string2 = this.message(redeemingNotAllowedForVoucherException.getStatus().getMessageKey(), new Object[0]);
            throw new SmsOperationException((Throwable)redeemingNotAllowedForVoucherException, (Object)RedeemVoucherError.REDEEMING_NOT_ALLOWED_FOR_VOUCHER.getMessageKey(), new Object[]{string2});
        }
        catch (RedeemingNotAllowedForUserException redeemingNotAllowedForUserException) {
            throw new SmsOperationException((Throwable)redeemingNotAllowedForUserException, (Object)RedeemVoucherError.REDEEMING_NOT_ALLOWED_FOR_USER.getMessageKey(), new Object[0]);
        }
        catch (RedeemingNotAllowedYetException redeemingNotAllowedYetException) {
            throw new SmsOperationException((Throwable)redeemingNotAllowedYetException, (Object)RedeemVoucherError.REDEEMING_NOT_ALLOWED_YET.getMessageKey(), new Object[]{redeemingNotAllowedYetException.getRedeemAfterDate()});
        }
        catch (RedeemingNotAllowedTodayException redeemingNotAllowedTodayException) {
            StringBuilder stringBuilder = new StringBuilder();
            for (WeekDay weekDay : redeemingNotAllowedTodayException.getAllowedDays()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.message(WeekDay.resolverForShort().resolveKey((Enum)weekDay), new Object[0]));
            }
            throw new SmsOperationException((Throwable)redeemingNotAllowedTodayException, (Object)RedeemVoucherError.REDEEMING_NOT_ALLOWED_TODAY.getMessageKey(), new Object[]{stringBuilder.toString()});
        }
        CurrencyVO currencyVO = voucherTransactionResultVO.getType().getConfiguration().getCurrency();
        BigDecimal bigDecimal = voucherTransactionResultVO.getAmount();
        CurrencyAmountDTO currencyAmountDTO = ModelHelper.currencyAmount((CurrencyVO)currencyVO, (BigDecimal)bigDecimal);
        this.sendResponse(mobilePhone, this.message(MessagingKeys.Notifications.SMS_REDEEM_VOUCHER_RESPONSE_SUCCESSFULLY, currencyAmountDTO));
    }

    @Override
    protected List<String> getHelpComponents(SmsOperationConfiguration smsOperationConfiguration) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.message(MessagingKeys.Notifications.SMS_REDEEM_VOUCHER_PARAMETER_TOKEN, new Object[0]));
        return arrayList;
    }

    private static enum RedeemVoucherError implements HasMessageKey
    {
        INVALID_TOKEN(MessagingKeys.Notifications.SMS_REDEEM_VOUCHER_ERROR_INVALID_TOKEN),
        USER_BLOCKED(MessagingKeys.Notifications.SMS_REDEEM_VOUCHER_ERROR_USER_BLOCKED),
        REDEEMING_NOT_ALLOWED_FOR_VOUCHER(MessagingKeys.Notifications.SMS_REDEEM_VOUCHER_ERROR_REDEEMING_NOT_ALLOWED_FOR_VOUCHER),
        REDEEMING_NOT_ALLOWED_FOR_USER(MessagingKeys.Notifications.SMS_REDEEM_VOUCHER_ERROR_REDEEMING_NOT_ALLOWED_FOR_USER),
        REDEEMING_NOT_ALLOWED_YET(MessagingKeys.Notifications.SMS_REDEEM_VOUCHER_ERROR_REDEEMING_NOT_ALLOWED_YET),
        REDEEMING_NOT_ALLOWED_TODAY(MessagingKeys.Notifications.SMS_REDEEM_VOUCHER_ERROR_REDEEMING_NOT_ALLOWED_TODAY);

        private MessageKey key;

        private RedeemVoucherError(MessageKey messageKey) {
            this.key = messageKey;
        }

        public MessageKey getMessageKey() {
            return this.key;
        }
    }
}

