/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.persistence;

import com.querydsl.core.FilteredClause;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QNetwork;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.server.utils.MethodHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.springframework.stereotype.Component;

@Component
public class NetworkPathRegistryImpl
implements NetworkPathRegistry {
    private Map<Class<? extends NetworkedEntity>, String[]> mappings = new HashMap<Class<? extends NetworkedEntity>, String[]>();
    private Set<Class<? extends NetworkedEntity>> showGlobals = new HashSet<Class<? extends NetworkedEntity>>();

    public void applyNetworkFilter(DBQuery<?> dBQuery, EntityPath<?> entityPath, Network network) {
        QNetwork qNetwork = this.resolve(entityPath);
        if (qNetwork != null) {
            if (network == null) {
                dBQuery.where((Predicate)qNetwork.isNull());
            } else {
                Class clazz = entityPath.getRoot().getType();
                if (this.showGlobals(clazz)) {
                    dBQuery.where((Predicate)qNetwork.isNull().or((Predicate)qNetwork.eq((Object)network)));
                } else {
                    dBQuery.where((Predicate)qNetwork.eq((Object)network));
                }
            }
        }
    }

    public void applyNetworkFilter(FilteredClause<?> filteredClause, EntityPath<?> entityPath, Network network) {
        QNetwork qNetwork = this.resolve(entityPath);
        if (qNetwork != null) {
            if (network == null) {
                filteredClause.where(new Predicate[]{qNetwork.isNull()});
            } else {
                filteredClause.where(new Predicate[]{qNetwork.eq((Object)network)});
            }
        }
    }

    public String getNetworkPath(Class<? extends NetworkedEntity> clazz) {
        Class<? extends NetworkedEntity> clazz2 = clazz;
        while (!NetworkedEntity.class.equals(clazz2) && !Object.class.equals(clazz2)) {
            Object[] objectArray = this.mappings.get(clazz2);
            if (objectArray != null) {
                return StringUtils.join((Object[])objectArray, (char)'.');
            }
            clazz2 = clazz2.getSuperclass();
        }
        return null;
    }

    public void register(QNetwork qNetwork) {
        this.register(qNetwork, false);
    }

    public void register(QNetwork qNetwork, boolean bl) {
        Path path = qNetwork.getRoot();
        Class clazz = path.getType();
        String string = PropertyHelper.getPropertyName((Path)qNetwork);
        this.mappings.put(clazz, StringUtils.split((String)string, (char)'.'));
        if (bl) {
            this.showGlobals.add(clazz);
        }
    }

    public QNetwork resolve(EntityPath<?> path) {
        Path path2 = path.getRoot();
        String[] stringArray = null;
        for (Class clazz = path2.getType(); stringArray == null && clazz != null; clazz = clazz.getSuperclass()) {
            stringArray = this.mappings.get(clazz);
        }
        if (stringArray == null) {
            return null;
        }
        Path path3 = path;
        for (String string : stringArray) {
            path3 = (Path)MethodHelper.invoke(path3, (String)string, (Object[])new Object[0]);
        }
        return (QNetwork)path3;
    }

    public boolean showGlobals(Class<? extends NetworkedEntity> clazz) {
        Class<? extends NetworkedEntity> clazz2 = clazz;
        while (!NetworkedEntity.class.equals(clazz2) && !Object.class.equals(clazz2)) {
            if (this.showGlobals.contains(clazz2)) {
                return true;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return false;
    }
}

