/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.db.DatabaseUpgradeException;
import org.cyclos.db.Migration;
import org.cyclos.db.VersionScript;
import org.cyclos.impl.system.FileScriptBackgroundTask;
import org.cyclos.impl.system.InlineScriptBackgroundTask;
import org.cyclos.model.system.scheduledtasks.BackgroundTaskPriority;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowCountCallbackHandler;

public class ScriptHelper {
    private static final Logger LOG = LogManager.getLogger(ScriptHelper.class);
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("^DELIMITER (\\S+)$", 2);
    private static final String CLASS_PREFIX = "class ";
    private static final String INLINE_SCRIPT_TASK_PREFIX = "background '";
    private static final String FILE_SCRIPT_TASK_PREFIX = "background /";

    public static void run(JdbcTemplate jdbcTemplate, String string, String string2, Integer n, boolean bl, CyclosProperties cyclosProperties) throws DatabaseUpgradeException {
        MutableObject mutableObject = new MutableObject();
        Consumer<Exception> consumer = exception -> {
            if (mutableObject.getValue() == null) {
                mutableObject.setValue(exception);
            }
        };
        List<String> list = ScriptHelper.split(string);
        for (String string3 : list) {
            if (string3.startsWith(CLASS_PREFIX)) {
                String string4 = StringUtils.trimToEmpty((String)StringUtils.removeStart((String)string3, (String)CLASS_PREFIX));
                try {
                    Class<?> clazz = Class.forName(string4);
                    Migration migration = (Migration)ClassHelper.instantiate(clazz);
                    migration.initialize(jdbcTemplate, cyclosProperties);
                    int n2 = migration.run();
                    if (!bl) continue;
                    LOG.info((String)ObjectHelper.defaultValue((Object)migration.getAffectedMessage(), (Object)"{} rows affected while executing migration class: {}"), (Object)n2, (Object)migration.getClass().getName());
                }
                catch (Exception exception2) {
                    consumer.accept(exception2);
                    LOG.error("Error on migration class: " + string4, (Throwable)exception2);
                }
                continue;
            }
            if (string3.startsWith(INLINE_SCRIPT_TASK_PREFIX) && string3.endsWith("'")) {
                try {
                    ScriptHelper.insertScriptedBackgroundTask(jdbcTemplate, bl, string3.substring(INLINE_SCRIPT_TASK_PREFIX.length(), string3.length() - 1), true, string2, n);
                }
                catch (Exception exception3) {
                    consumer.accept(exception3);
                    LOG.error("Error on scripted background task: " + string3, (Throwable)exception3);
                }
                continue;
            }
            if (string3.startsWith(FILE_SCRIPT_TASK_PREFIX) && string3.endsWith(".groovy")) {
                try {
                    ScriptHelper.insertScriptedBackgroundTask(jdbcTemplate, bl, string3.substring(FILE_SCRIPT_TASK_PREFIX.length() - 1), false, string2, n);
                }
                catch (Exception exception4) {
                    consumer.accept(exception4);
                    LOG.error("Error on scripted background task: " + string3, (Throwable)exception4);
                }
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)string3, (CharSequence)"select")) {
                try {
                    RowCountCallbackHandler rowCountCallbackHandler = new RowCountCallbackHandler();
                    jdbcTemplate.query(string3, (RowCallbackHandler)rowCountCallbackHandler);
                    if (!bl) continue;
                    LOG.info("{} rows affected while executing statement: {}", (Object)rowCountCallbackHandler.getRowCount(), (Object)string3);
                }
                catch (Exception exception5) {
                    consumer.accept(exception5);
                    LOG.error("Error on statement: " + string3, (Throwable)exception5);
                }
                continue;
            }
            try {
                int n3 = jdbcTemplate.update(string3);
                if (!bl) continue;
                LOG.info("{} rows affected while executing statement: {}", (Object)n3, (Object)string3);
            }
            catch (Exception exception6) {
                consumer.accept(exception6);
                LOG.error("Error on statement: " + string3, (Throwable)exception6);
            }
        }
        if (mutableObject.getValue() != null) {
            throw new DatabaseUpgradeException((Throwable)mutableObject.getValue());
        }
    }

    public static boolean runSilently(JdbcTemplate jdbcTemplate, String string, boolean bl, CyclosProperties cyclosProperties) {
        try {
            ScriptHelper.run(jdbcTemplate, string, null, null, bl, cyclosProperties);
            return false;
        }
        catch (DatabaseUpgradeException databaseUpgradeException) {
            return true;
        }
    }

    public static boolean runSilently(JdbcTemplate jdbcTemplate, String string, VersionScript versionScript, boolean bl, CyclosProperties cyclosProperties) {
        try {
            ScriptHelper.run(jdbcTemplate, versionScript.getScript(), string, versionScript.getVersion(), bl, cyclosProperties);
            return false;
        }
        catch (DatabaseUpgradeException databaseUpgradeException) {
            return true;
        }
    }

    public static List<String> split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string2 = ";";
        try {
            String string3;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string3 = bufferedReader.readLine()) != null) {
                if ((string3 = string3.trim()).length() == 0 || string3.startsWith("--")) continue;
                Matcher matcher = DELIMITER_PATTERN.matcher(string3);
                if (matcher.find()) {
                    string2 = matcher.group(1);
                    continue;
                }
                if (string3.endsWith(string2)) {
                    string3 = string3.substring(0, string3.length() - string2.length());
                    stringBuilder.append(string3);
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                stringBuilder.append(string3).append('\n');
            }
            if (stringBuilder.length() > 0) {
                arrayList.add(stringBuilder.toString());
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"IOException reading from an in-memory string?!?");
        }
        return arrayList;
    }

    private static void insertScriptedBackgroundTask(JdbcTemplate jdbcTemplate, boolean bl, String string, boolean bl2, String string2, Integer n) {
        List list;
        String string3 = bl2 ? InlineScriptBackgroundTask.class.getName() : FileScriptBackgroundTask.class.getName();
        String string4 = "delete from background_task_executions where class_name = ? and context = ?";
        int n2 = jdbcTemplate.update(string4, new Object[]{string3, string});
        if (bl) {
            LOG.info("{} rows affected while executing statement generated for background task: {}", (Object)n2, (Object)string4);
        }
        if ((list = StringHelper.split((String)string2, (String)".")).size() == 2 && ((String)list.get(0)).equals("4") && Integer.valueOf((String)list.get(1)) < 16) {
            string4 = "insert into background_task_executions (class_name, context) values (?, ?)";
            n2 = jdbcTemplate.update(string4, new Object[]{string3, string});
        } else {
            String string5 = string2 != null && n != null ? "Migration " + string2 + " - " + n : "Migration";
            string4 = "insert into background_task_executions (class_name, context, display, priority) values (?, ?, ?, ?)";
            n2 = jdbcTemplate.update(string4, new Object[]{string3, string, string5, BackgroundTaskPriority.HIGH.ordinal()});
        }
        if (bl) {
            LOG.info("{} rows affected while executing statement generated for background task: {}", (Object)n2, (Object)string4);
        }
    }
}

