/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cluster;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.cyclos.impl.sql.DbLockHandler;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.utils.NoClusterProfilingManagerImpl;
import org.cyclos.impl.utils.NoClusterPushNotificationHandlerImpl;
import org.cyclos.impl.utils.PushNotificationHandler;
import org.cyclos.impl.utils.cache.CacheHandlerImplementor;
import org.cyclos.impl.utils.cache.GuavaCacheHandlerImpl;
import org.cyclos.impl.utils.cluster.AbstractClusterHandlerImpl;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.MemberRunningTaskDescriptor;
import org.cyclos.impl.utils.cluster.NoClusterRecurringTaskHandlerImpl;
import org.cyclos.impl.utils.cluster.ProfilingManager;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionContext;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionKey;
import org.cyclos.impl.utils.tasks.RecurringTaskHandlerImplementor;
import org.cyclos.impl.utils.tasks.RunningTaskDescriptor;
import org.cyclos.model.system.monitor.CacheQuery;
import org.cyclos.model.system.monitor.ServerData;
import org.cyclos.model.utils.CacheVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.CannotGetJdbcConnectionException;

public class NoClusterHandlerImpl
extends AbstractClusterHandlerImpl {
    @Autowired
    @Lazy
    protected ConversionHandler conversionHandler;
    @Autowired
    protected NativeQueryHandler nativeQueryHandler;
    private boolean alive;
    private boolean databaseLocked;
    private String hostId;
    private long startupTime;
    private Set<BackgroundTaskExecutionKey> runningBackgroundTasks = Collections.synchronizedSet(new HashSet());
    private Set<Long> finishedBackgroundTasks = new HashSet<Long>();
    private BlockingQueue<BackgroundTaskExecutionContext> backgroundTaskQueue;
    private Timer keepalive;

    public NoClusterHandlerImpl() {
        try (DatagramSocket datagramSocket = new DatagramSocket();){
            datagramSocket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            this.hostId = datagramSocket.getLocalAddress().getHostAddress();
        }
        catch (Exception exception) {
            this.hostId = "localhost";
        }
    }

    public void clearCaches() {
        this.getCacheHandler().clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBackgroundTaskExecution(BackgroundTaskExecutionContext backgroundTaskExecutionContext) {
        Set<Long> set = this.finishedBackgroundTasks;
        synchronized (set) {
            this.finishedBackgroundTasks.addAll(backgroundTaskExecutionContext.getExecutionIds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getBackgroundTaskExecutions() {
        Set set;
        Set set2 = set = this.backgroundTaskHandler.getRunningTasks();
        synchronized (set2) {
            return set.stream().collect(Collectors.toMap(RunningTaskDescriptor::getTaskName, runningTaskDescriptor -> 1, (n, n2) -> n + n2));
        }
    }

    public List<CacheVO> getCachesInformation(CacheQuery cacheQuery) {
        return this.systemMonitorService.listLocalCaches(cacheQuery);
    }

    public Map<String, List<CacheVO>> getCachesInformationByMember(CacheQuery cacheQuery) {
        return Collections.singletonMap("localhost", this.getCachesInformation(cacheQuery));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterHandler.FinishedExecutionsHandler getFinishedBackgroundTaskExecutions() {
        Set<Long> set = this.finishedBackgroundTasks;
        synchronized (set) {
            return new AbstractClusterHandlerImpl.FinishedExecutionsHandlerImpl(new HashSet<Long>(this.finishedBackgroundTasks));
        }
    }

    public Map<String, Object> getGlobal(String string) {
        return Collections.singletonMap(this.getHostId(), this.scriptHelper.getGlobals().get(string));
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getMemberConfiguration() {
        return null;
    }

    public MemberRunningTaskDescriptor getMemberRunningTask(String string) {
        return this.recurringTaskHandler.getRunningTasks().stream().filter(runningTaskDescriptor -> runningTaskDescriptor.getTaskName().equals(string)).map(runningTaskDescriptor -> new MemberRunningTaskDescriptor(this.getHostId(), runningTaskDescriptor)).findAny().orElse(null);
    }

    public List<ServerData> getMembersData() {
        ArrayList<ServerData> arrayList = new ArrayList<ServerData>();
        ServerData serverData = this.systemMonitorService.getServerData();
        serverData.setUpSince(this.conversionHandler.toDateTime(new Date(this.startupTime)));
        serverData.setUptimeInMillis(String.valueOf(System.currentTimeMillis() - this.startupTime));
        serverData.setMemberName(this.getHostId());
        arrayList.add(serverData);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, MemberRunningTaskDescriptor> getRunningRecurringTasks() {
        Set set;
        Set set2 = set = this.recurringTaskHandler.getRunningTasks();
        synchronized (set2) {
            return set.stream().map(runningTaskDescriptor -> new MemberRunningTaskDescriptor(this.getHostId(), runningTaskDescriptor)).collect(Collectors.toMap(memberRunningTaskDescriptor -> memberRunningTaskDescriptor.getTaskDescriptor().getTaskName(), memberRunningTaskDescriptor -> memberRunningTaskDescriptor));
        }
    }

    @Override
    @PostConstruct
    public void initialize() {
        this.startupTime = System.currentTimeMillis();
        this.alive = true;
        this.backgroundTaskQueue = new LinkedBlockingQueue<BackgroundTaskExecutionContext>();
        super.initialize();
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean isCluster() {
        return false;
    }

    @Override
    public boolean lockDatabase() {
        boolean bl;
        this.databaseLocked = bl = super.lockDatabase();
        return bl;
    }

    public void starTaskTimers() {
        this.recurringTaskHandler.scheduleTasks();
        if (!this.ignoreDbLock) {
            this.scheduleKeepAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRemoveFinishedBackgroundTaskExecutions(List<Long> list) {
        Set<Long> set = this.finishedBackgroundTasks;
        synchronized (set) {
            this.finishedBackgroundTasks.removeAll(list);
        }
    }

    @Override
    protected BlockingQueue<BackgroundTaskExecutionContext> getBackgroundTaskQueue() {
        return this.backgroundTaskQueue;
    }

    @Override
    protected int getBackgroundTaskThreads() {
        return this.cyclosProperties.getMaxBackgroundTasks();
    }

    @Override
    protected CacheHandlerImplementor instantiateCacheHandler() {
        return new GuavaCacheHandlerImpl();
    }

    @Override
    protected ProfilingManager instantiateProfilingManager() {
        return new NoClusterProfilingManagerImpl();
    }

    @Override
    protected PushNotificationHandler instantiatePushNotificationHandler() {
        return new NoClusterPushNotificationHandlerImpl();
    }

    @Override
    protected RecurringTaskHandlerImplementor instantiateRecurringTaskHandler() {
        return new NoClusterRecurringTaskHandlerImpl();
    }

    @Override
    protected void runBackgroundTask(BackgroundTaskExecutionContext backgroundTaskExecutionContext) {
        if (!this.runningBackgroundTasks.add(backgroundTaskExecutionContext.getKey())) {
            return;
        }
        try {
            super.runBackgroundTask(backgroundTaskExecutionContext);
        }
        finally {
            this.runningBackgroundTasks.remove(backgroundTaskExecutionContext.getKey());
        }
    }

    @Override
    protected boolean shouldEnsureDatabaseIsNotLocked() {
        return true;
    }

    @Override
    protected boolean shouldUnlockDatabase() {
        return this.databaseLocked;
    }

    @PreDestroy
    protected void shutdown() {
        this.alive = false;
        if (this.keepalive != null) {
            this.keepalive.cancel();
        }
    }

    private void scheduleKeepAlive() {
        final DbLockHandler dbLockHandler = this.nativeQueryHandler.getDbLockHandler();
        this.keepalive = new Timer("cy.dblock_keepalive");
        int n = 6000;
        this.keepalive.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                while (true) {
                    try {
                        dbLockHandler.keepalive(NoClusterHandlerImpl.this.getHostId());
                        return;
                    }
                    catch (CannotGetJdbcConnectionException cannotGetJdbcConnectionException) {
                        return;
                    }
                    catch (Exception exception) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
            }
        }, (long)Math.random() * (long)n, (long)n);
    }
}

