/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.coercion.CoercionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IdMaskJacksonConfiguration {
    @Autowired
    private JacksonConfiguration jacksonConfiguration;
    @Autowired
    private ApplicationHandler applicationHandler;
    private ObjectMapper objectMapper;

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @PostConstruct
    public void initialize() {
        this.objectMapper = this.jacksonConfiguration.getObjectMapper().copy();
        SimpleModule simpleModule = new SimpleModule("IdMask");
        simpleModule.addSerializer(Long.class, (JsonSerializer)new IdMaskSerializer(Long.class));
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)new IdMaskSerializer(Long.TYPE));
        simpleModule.addDeserializer(Long.class, (JsonDeserializer)new IdMaskDeserializer(Long.class));
        simpleModule.addDeserializer(Long.TYPE, (JsonDeserializer)new IdMaskDeserializer(Long.TYPE));
        this.objectMapper.registerModule((Module)simpleModule);
    }

    private class IdMaskSerializer
    extends StdScalarSerializer<Long> {
        private static final long serialVersionUID = 1L;

        protected IdMaskSerializer(Class<Long> clazz) {
            super(clazz);
        }

        public void serialize(Long l, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            Long l2 = IdMaskJacksonConfiguration.this.applicationHandler.getIdMask().apply(l);
            jsonGenerator.writeString(l2.toString());
        }
    }

    private class IdMaskDeserializer
    extends StdScalarDeserializer<Long> {
        private static final long serialVersionUID = 1L;

        protected IdMaskDeserializer(Class<Long> clazz) {
            super(clazz);
        }

        public Long deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            Long l = null;
            if (jsonToken == JsonToken.VALUE_STRING) {
                String string = jsonParser.getText();
                if (string != null) {
                    try {
                        l = Long.parseLong(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new CoercionException(string, (Throwable)numberFormatException);
                    }
                }
            } else if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                l = jsonParser.getNumberValue().longValue();
            }
            return IdMaskJacksonConfiguration.this.applicationHandler.getIdMask().remove(l);
        }
    }
}

