/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.cyclos.impl.utils.GuavaStorage;
import org.cyclos.impl.utils.LocalStorage;
import org.cyclos.impl.utils.cluster.LocalStorageType;

public class GuavaLocalStorage<K, V>
extends GuavaStorage<K, V, BiPredicate<K, V>>
implements LocalStorage<K, V> {
    private List<BiConsumer<K, V>> listeners = new ArrayList<BiConsumer<K, V>>();

    public GuavaLocalStorage(LocalStorageType<K, V> localStorageType) {
        super(localStorageType);
    }

    public void addRemoveListener(BiConsumer<K, V> biConsumer) {
        this.listeners.add(biConsumer);
    }

    public V get(K k, Callable<V> callable) {
        try {
            return (V)this.cache.get(k, callable);
        }
        catch (ExecutionException executionException) {
            throw new IllegalStateException("Error producing a cache value for key " + String.valueOf(k) + " in storage " + String.valueOf(this.type));
        }
    }

    @Override
    protected void onRemove(K k, V v) {
        this.listeners.forEach(biConsumer -> biConsumer.accept(k, v));
    }
}

