/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.util.Set;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.User;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.GroupList;
import org.cyclos.impl.users.GroupListViewFactory;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractUserVisibilityApplier {
    protected SessionData sessionData;
    @Autowired
    private GroupsHandler groupsHandler;

    public final void apply(boolean bl, GroupList groupList, boolean bl2) {
        SessionData sessionData = InvocationContext.getSessionData();
        GroupListViewFactory groupListViewFactory = this.groupsHandler.viewFactory(groupList);
        if (bl2) {
            groupListViewFactory = groupListViewFactory.includeGlobals();
        }
        Set set = groupListViewFactory.groups().items();
        if (sessionData.isBroker()) {
            if (CollectionHelper.isEmpty((Iterable)set)) {
                this.applyBrokerOrSelf(sessionData.getLoggedUser());
            } else {
                this.applyGroupsOrBrokerOrSelf(set, sessionData.getLoggedUser());
            }
        } else if (sessionData.isMember()) {
            if (bl || CollectionHelper.isEmpty((Iterable)set)) {
                this.applySelf(sessionData.getLoggedUser());
            } else {
                this.applyGroupsOrSelf(set, sessionData.getLoggedUser());
            }
        } else if (CollectionHelper.isEmpty((Iterable)set)) {
            this.bogusCondition();
        } else {
            this.applyGroups(set);
        }
    }

    public final void onlySelf() {
        this.apply(true, GroupList.ACCESSIBLE, false);
    }

    public final void onlySelf(GroupList groupList) {
        this.apply(true, groupList, false);
    }

    public final void others() {
        this.apply(false, GroupList.ACCESSIBLE, false);
    }

    public final void others(boolean bl) {
        this.apply(false, GroupList.ACCESSIBLE, bl);
    }

    public final void others(GroupList groupList) {
        this.apply(false, groupList, false);
    }

    public final void others(GroupList groupList, boolean bl) {
        this.apply(false, groupList, bl);
    }

    protected abstract void applyBrokerOrSelf(User var1);

    protected abstract void applyGroups(Set<Group> var1);

    protected abstract void applyGroupsOrBrokerOrSelf(Set<Group> var1, User var2);

    protected abstract void applyGroupsOrSelf(Set<Group> var1, User var2);

    protected abstract void applySelf(User var1);

    protected abstract void bogusCondition();
}

